/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.client.interceptors;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.sklsft.commons.api.context.RequestChannels;
import org.sklsft.commons.log.AccessLogger;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;

public class RestClientLoggerInterceptor
implements ClientHttpRequestInterceptor {
    private AccessLogger accessLogger;
    private boolean traceRequestPayload = true;
    private boolean traceResponsePayload = false;

    public void setAccessLogger(AccessLogger accessLogger) {
        this.accessLogger = accessLogger;
    }

    public void setTraceRequestPayload(boolean traceRequestPayload) {
        this.traceRequestPayload = traceRequestPayload;
    }

    public void setTraceResponsePayload(boolean traceResponsePayload) {
        this.traceResponsePayload = traceResponsePayload;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.traceRequest(request, body);
        long start = System.currentTimeMillis();
        ClientHttpResponse response = execution.execute(request, body);
        long elapsedTime = System.currentTimeMillis() - start;
        this.traceResponse(request, response, elapsedTime);
        return response;
    }

    private void traceRequest(HttpRequest request, byte[] body) throws IOException {
        String interfaceName = request.getMethod() + " " + request.getURI();
        String sentPayload = null;
        if (this.traceRequestPayload && !request.getMethod().equals((Object)HttpMethod.GET)) {
            sentPayload = new String(body, "UTF-8");
        }
        this.accessLogger.logInterfaceCall(interfaceName, RequestChannels.HTTP_REST, sentPayload);
    }

    private void traceResponse(HttpRequest request, ClientHttpResponse response, long elapsedTime) throws IOException {
        String status = response.getStatusCode().toString();
        String message = response.getStatusText();
        String receivedPayload = null;
        String interfaceName = request.getMethod() + " " + request.getURI();
        if (this.traceResponsePayload && response.getBody() != null) {
            receivedPayload = StreamUtils.copyToString((InputStream)response.getBody(), (Charset)StandardCharsets.UTF_8);
        }
        this.accessLogger.logInterfaceAnswer(interfaceName, RequestChannels.HTTP_REST, (Object)receivedPayload, Long.valueOf(elapsedTime), status, message);
    }
}

