/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.client;

import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.RestTemplate;

public class RestClient {
    private String restServerUrl;
    private RestTemplate restTemplate;

    public void setRestServerUrl(String restServerUrl) {
        this.restServerUrl = restServerUrl;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public <T> T getForObject(String relativeUrl, Class<T> responseClass) {
        return (T)this.restTemplate.getForObject(this.getFullUrl(relativeUrl), responseClass, new Object[0]);
    }

    public <T> T getForObject(String relativeUrl, Class<T> responseClass, Map<String, ?> uriVariables) {
        return (T)this.restTemplate.getForObject(this.getFullUrl(relativeUrl), responseClass, uriVariables);
    }

    public <T> T getForObject(String relativeUrl, ParameterizedTypeReference<T> type) {
        return (T)this.restTemplate.exchange(this.getFullUrl(relativeUrl), HttpMethod.GET, null, type, new Object[0]).getBody();
    }

    public <T> T getForObject(String relativeUrl, ParameterizedTypeReference<T> type, Map<String, ?> uriVariables) {
        return (T)this.restTemplate.exchange(this.getFullUrl(relativeUrl), HttpMethod.GET, null, type, uriVariables).getBody();
    }

    public <T> T postForObject(String relativeUrl, Object form, Class<T> responseClass) {
        return (T)this.restTemplate.postForObject(this.getFullUrl(relativeUrl), form, responseClass, new Object[0]);
    }

    public <T> T postForObject(String relativeUrl, Object form, Class<T> responseClass, Map<String, ?> uriVariables) {
        return (T)this.restTemplate.postForObject(this.getFullUrl(relativeUrl), form, responseClass, uriVariables);
    }

    public <T> T postForObject(String relativeUrl, Object form, ParameterizedTypeReference<T> type) {
        HttpEntity httpEntity = new HttpEntity(form);
        return (T)this.restTemplate.exchange(this.getFullUrl(relativeUrl), HttpMethod.POST, httpEntity, type, new Object[0]).getBody();
    }

    public <T> T postForObject(String relativeUrl, Object form, ParameterizedTypeReference<T> type, Map<String, ?> uriVariables) {
        HttpEntity httpEntity = new HttpEntity(form);
        return (T)this.restTemplate.exchange(this.getFullUrl(relativeUrl), HttpMethod.POST, httpEntity, type, uriVariables).getBody();
    }

    public void put(String relativeUrl, Object form) {
        this.restTemplate.put(this.getFullUrl(relativeUrl), form, new Object[0]);
    }

    public void put(String relativeUrl, Object form, Map<String, ?> uriVariables) {
        this.restTemplate.put(this.getFullUrl(relativeUrl), form, uriVariables);
    }

    public void delete(String relativeUrl, Map<String, ?> uriVariables) {
        this.restTemplate.delete(this.getFullUrl(relativeUrl), uriVariables);
    }

    public <T> T exchange(String relativeUrl, HttpMethod method, Object form, Class<T> type) {
        HttpEntity httpEntity = null;
        if (null != form) {
            httpEntity = new HttpEntity(form);
        }
        return (T)this.restTemplate.exchange(this.getFullUrl(relativeUrl), method, httpEntity, type, new Object[0]).getBody();
    }

    public <T> T exchange(String relativeUrl, HttpMethod method, Object form, Class<T> type, Map<String, ?> uriVariables) {
        HttpEntity httpEntity = null;
        if (null != form) {
            httpEntity = new HttpEntity(form);
        }
        return (T)this.restTemplate.exchange(this.getFullUrl(relativeUrl), method, httpEntity, type, uriVariables).getBody();
    }

    public <T> T exchange(String relativeUrl, HttpMethod method, Object form, ParameterizedTypeReference<T> type) {
        HttpEntity httpEntity = null;
        if (null != form) {
            httpEntity = new HttpEntity(form);
        }
        return (T)this.restTemplate.exchange(this.getFullUrl(relativeUrl), method, httpEntity, type, new Object[0]).getBody();
    }

    public <T> T exchange(String relativeUrl, HttpMethod method, Object form, ParameterizedTypeReference<T> type, Map<String, ?> uriVariables) {
        HttpEntity httpEntity = null;
        if (null != form) {
            httpEntity = new HttpEntity(form);
        }
        return (T)this.restTemplate.exchange(this.getFullUrl(relativeUrl), method, httpEntity, type, uriVariables).getBody();
    }

    private String getFullUrl(String relativeUrl) {
        return this.restServerUrl + relativeUrl;
    }
}

