/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.client.interceptors;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.sklsft.commons.log.AccessLogger;
import org.sklsft.commons.log.context.RequestChannels;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;

public class RestClientLoggerInterceptor
implements ClientHttpRequestInterceptor {
    private AccessLogger accessLogger;
    private boolean traceSentBody = true;
    private boolean traceReceivedBody = false;

    public void setAccessLogger(AccessLogger accessLogger) {
        this.accessLogger = accessLogger;
    }

    public void setTraceSentBody(boolean traceSentBody) {
        this.traceSentBody = traceSentBody;
    }

    public void setTraceReceivedBody(boolean traceReceivedBody) {
        this.traceReceivedBody = traceReceivedBody;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.traceRequest(request, body);
        long start = System.currentTimeMillis();
        ClientHttpResponse response = execution.execute(request, body);
        this.traceResponse(request, response, start);
        return response;
    }

    private void traceRequest(HttpRequest request, byte[] body) throws IOException {
        String interfaceName = request.getMethod() + " " + request.getURI();
        String sentPayload = null;
        if (this.traceSentBody && !request.getMethod().equals((Object)HttpMethod.GET)) {
            sentPayload = StreamUtils.copyToString((InputStream)new ByteArrayInputStream(body), (Charset)StandardCharsets.UTF_8);
        }
        this.accessLogger.logInterfaceCall(interfaceName, RequestChannels.HTTP_REST, sentPayload);
    }

    private void traceResponse(HttpRequest request, ClientHttpResponse response, long start) throws IOException {
        String status = response.getStatusCode().toString();
        String message = response.getStatusText();
        String receivedPayload = null;
        String interfaceName = request.getMethod() + " " + request.getURI();
        if (this.traceReceivedBody && response.getBody() != null) {
            receivedPayload = StreamUtils.copyToString((InputStream)response.getBody(), (Charset)StandardCharsets.UTF_8);
        }
        long elapsedTime = System.currentTimeMillis() - start;
        this.accessLogger.logInterfaceAnswer(interfaceName, RequestChannels.HTTP_REST, (Object)receivedPayload, Long.valueOf(elapsedTime), status, message);
    }
}

