/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.client.exception;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.sklsft.commons.api.exception.ApplicationException;
import org.sklsft.commons.api.exception.ErrorReport;
import org.sklsft.commons.api.exception.TechnicalError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.ResponseErrorHandler;

public class ErrorReportHandler
implements ResponseErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(ErrorReportHandler.class);
    private ObjectMapper objectMapper;

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean hasError(ClientHttpResponse response) throws IOException {
        return !response.getStatusCode().equals((Object)HttpStatus.OK);
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        try {
            ErrorReport errorReport = (ErrorReport)this.objectMapper.readValue(response.getBody(), ErrorReport.class);
            this.convertErrorReport(errorReport);
        }
        catch (IOException e) {
            logger.warn("Could not read error report : a TechnicalError will be thrown");
            throw new TechnicalError("error.unknown", (Throwable)e);
        }
    }

    public void convertErrorReport(ErrorReport errorReport) {
        ApplicationException exception;
        try {
            exception = (ApplicationException)Class.forName(errorReport.getExceptionClassName()).newInstance();
            exception.setMessage(errorReport.getMessage());
        }
        catch (Exception e) {
            logger.warn("Could not instantiate exception from rest response : a TechnicalError will be used instead");
            exception = new TechnicalError("error.unknown", (Throwable)e);
        }
        throw exception;
    }
}

