/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.security;

import org.sklsft.commons.crypto.ObjectEncoder;
import org.sklsft.commons.rest.security.exception.InvalidTokenException;

public class SecurityCredentialsEncoder<T> {
    private ObjectEncoder objectEncoder;
    private Class<T> credentialsClass;

    public SecurityCredentialsEncoder(ObjectEncoder objectEncoder, Class<T> credentialsClass) {
        this.objectEncoder = objectEncoder;
        this.credentialsClass = credentialsClass;
    }

    public T decode(String token) {
        try {
            return (T)this.objectEncoder.decode(token, this.credentialsClass);
        }
        catch (Exception e) {
            throw new InvalidTokenException("token.invalid", e);
        }
    }

    public String encode(Object credentials) {
        return this.objectEncoder.encode(credentials);
    }
}

