/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.security.aspect;

import org.sklsft.commons.rest.security.SecurityCredentialsEncoder;
import org.sklsft.commons.rest.security.context.SecurityContextHolder;
import org.sklsft.commons.rest.security.validation.SecurityCredentialsValidator;

public class SecurityContextProvider<T> {
    private SecurityCredentialsEncoder<T> decoder;
    private SecurityCredentialsValidator<T> validator;

    public SecurityContextProvider(SecurityCredentialsEncoder<T> decoder, SecurityCredentialsValidator<T> validator) {
        this.decoder = decoder;
        this.validator = validator;
    }

    public void provideSecurityContext(String token) {
        T credentials = this.decoder.decode(token);
        this.validator.validateCredentials(credentials);
        SecurityContextHolder.bindCredentials(credentials);
    }

    public void clearSecurityContext() {
        SecurityContextHolder.unbindCredentials();
    }
}

