/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.security.context.impl;

import org.sklsft.commons.rest.security.SecurityCredentialsEncoder;
import org.sklsft.commons.rest.security.context.SecurityContextHolder;
import org.sklsft.commons.rest.security.context.SecurityContextProvider;
import org.sklsft.commons.rest.security.validation.SecurityCredentialsValidator;

public class CryptedAppKeySecurityContextProvider<T, V>
implements SecurityContextProvider {
    private SecurityCredentialsEncoder<T> userCredentialsEncoder;
    private SecurityCredentialsValidator<T> userCredentialsValidator;
    private SecurityCredentialsEncoder<V> applicationCredentialsEncoder;
    private SecurityCredentialsValidator<V> applicationCredentialsValidator;

    public CryptedAppKeySecurityContextProvider(SecurityCredentialsEncoder<T> userCredentialsEncoder, SecurityCredentialsValidator<T> userCredentialsValidator, SecurityCredentialsEncoder<V> applicationCredentialsEncoder, SecurityCredentialsValidator<V> applicationCredentialsValidator) {
        this.userCredentialsEncoder = userCredentialsEncoder;
        this.userCredentialsValidator = userCredentialsValidator;
        this.applicationCredentialsEncoder = applicationCredentialsEncoder;
        this.applicationCredentialsValidator = applicationCredentialsValidator;
    }

    @Override
    public void provideUserSecurityContext(String token) {
        T credentials = this.userCredentialsEncoder.decode(token);
        this.userCredentialsValidator.validateCredentials(credentials);
        SecurityContextHolder.bindUserCredentials(credentials);
    }

    @Override
    public void provideApplicationSecurityContext(String secretKey) {
        V credentials = this.applicationCredentialsEncoder.decode(secretKey);
        this.applicationCredentialsValidator.validateCredentials(credentials);
        SecurityContextHolder.bindApplicationCredentials(credentials);
    }

    @Override
    public void clearSecurityContext() {
        SecurityContextHolder.unbindCredentials();
    }
}

