/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.security.context.impl;

import org.sklsft.commons.rest.security.context.ApplicationCredentialsRetriever;
import org.sklsft.commons.rest.security.context.SecurityContextHolder;
import org.sklsft.commons.rest.security.context.SecurityContextProvider;
import org.sklsft.commons.rest.security.context.SecurityCredentialsEncoder;
import org.sklsft.commons.rest.security.validation.SecurityCredentialsValidator;

public class PlainAppKeySecurityContextProvider<T, V>
implements SecurityContextProvider {
    private SecurityCredentialsEncoder<T> userCredentialsEncoder;
    private SecurityCredentialsValidator<T> userCredentialsValidator;
    private ApplicationCredentialsRetriever<V> applicationCredentialsRetriever;

    public PlainAppKeySecurityContextProvider(SecurityCredentialsEncoder<T> userCredentialsEncoder, SecurityCredentialsValidator<T> userCredentialsValidator, ApplicationCredentialsRetriever<V> applicationCredentialsRetriever) {
        this.userCredentialsEncoder = userCredentialsEncoder;
        this.userCredentialsValidator = userCredentialsValidator;
        this.applicationCredentialsRetriever = applicationCredentialsRetriever;
    }

    @Override
    public void provideUserSecurityContext(String token) {
        T credentials = this.userCredentialsEncoder.decode(token);
        this.userCredentialsValidator.validateCredentials(credentials);
        SecurityContextHolder.bindUserCredentials(credentials);
    }

    @Override
    public void provideApplicationSecurityContext(String secretKey) {
        V credentials = this.applicationCredentialsRetriever.retrieveApplicationCredentials(secretKey);
        SecurityContextHolder.bindApplicationCredentials(credentials);
    }

    @Override
    public void clearSecurityContext() {
        SecurityContextHolder.unbindCredentials();
    }
}

