/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.security.aspect;

import javax.servlet.http.Cookie;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.sklsft.commons.rest.security.annotations.DocumentAccessControl;
import org.sklsft.commons.rest.security.aspect.AccessControlAspect;
import org.sklsft.commons.rest.security.context.SecurityContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class DocumentAccessControlAspect {
    private static final Logger logger = LoggerFactory.getLogger(AccessControlAspect.class);
    private SecurityContextProvider securityContextProvider;

    public DocumentAccessControlAspect(SecurityContextProvider securityContextProvider) {
        this.securityContextProvider = securityContextProvider;
    }

    @Around(value="@annotation(documentAccessControl)")
    public Object handleAuthentication(ProceedingJoinPoint joinPoint, DocumentAccessControl documentAccessControl) throws Throwable {
        try {
            String token = this.extractCookie("img");
            this.securityContextProvider.provideUserSecurityContext(token);
            Object object = joinPoint.proceed();
            return object;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw t;
        }
        finally {
            this.securityContextProvider.clearSecurityContext();
        }
    }

    private String extractCookie(String key) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        Cookie[] cookies = servletRequestAttributes.getRequest().getCookies();
        String imageToken = null;
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(key)) continue;
            imageToken = cookie.getValue();
            break;
        }
        return imageToken;
    }
}

