/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.security.context.impl;

import org.sklsft.commons.rest.security.context.SecurityContextHolder;
import org.sklsft.commons.rest.security.context.SecurityContextProvider;
import org.sklsft.commons.rest.security.context.SecurityCredentialsEncoder;
import org.sklsft.commons.rest.security.validation.SecurityCredentialsValidator;

public class WeakSecurityContextProvider<T>
implements SecurityContextProvider {
    private SecurityCredentialsEncoder<T> userCredentialsEncoder;
    private SecurityCredentialsValidator<T> userCredentialsValidator;

    public WeakSecurityContextProvider(SecurityCredentialsEncoder<T> userCredentialsEncoder, SecurityCredentialsValidator<T> userCredentialsValidator) {
        this.userCredentialsEncoder = userCredentialsEncoder;
        this.userCredentialsValidator = userCredentialsValidator;
    }

    @Override
    public void provideUserSecurityContext(String token) {
        T credentials = this.userCredentialsEncoder.decode(token);
        this.userCredentialsValidator.validateCredentials(credentials);
        SecurityContextHolder.bindUserCredentials(credentials);
    }

    @Override
    public void provideApplicationSecurityContext(String secretKey) {
    }

    @Override
    public void clearSecurityContext() {
        SecurityContextHolder.unbindCredentials();
    }
}

