/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.security.access;

import org.sklsft.commons.rest.security.access.AccessControlType;
import org.sklsft.commons.rest.security.context.SecurityContextProvider;
import org.sklsft.commons.rest.security.tokens.TokenExtractionMode;
import org.sklsft.commons.rest.security.tokens.impl.TokenExtractorFactory;

public class AccessController {
    private SecurityContextProvider securityContextProvider;
    private TokenExtractorFactory tokenExtractorFactory = new TokenExtractorFactory();
    private String applicationTokenName;
    private String userTokenName;

    public AccessController(SecurityContextProvider securityContextProvider, String applicationTokenName, String userTokenName) {
        this.securityContextProvider = securityContextProvider;
        this.applicationTokenName = applicationTokenName;
        this.userTokenName = userTokenName;
    }

    public void handshake(AccessControlType accessControlType, TokenExtractionMode tokenExtractionMode) {
        if (!accessControlType.equals((Object)AccessControlType.PUBLIC)) {
            String secretKey = this.extractToken(this.applicationTokenName, tokenExtractionMode);
            this.securityContextProvider.provideApplicationSecurityContext(secretKey);
        }
        if (accessControlType.equals((Object)AccessControlType.PRIVATE)) {
            String token = this.extractToken(this.userTokenName, tokenExtractionMode);
            this.securityContextProvider.provideUserSecurityContext(token);
        }
    }

    private String extractToken(String key, TokenExtractionMode tokenExtractionMode) {
        String result = this.tokenExtractorFactory.getTokenExtractor(tokenExtractionMode).extractToken(key);
        return result;
    }
}

