/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.security.access;

import org.sklsft.commons.rest.security.access.AccessControlType;
import org.sklsft.commons.rest.security.context.SecurityContextProvider;
import org.sklsft.commons.rest.security.tokens.extraction.TokenExtractionMode;
import org.sklsft.commons.rest.security.tokens.extraction.impl.TokenExtractorFactory;

public class AccessController {
    private SecurityContextProvider anonymousSecurityContextProvider;
    private SecurityContextProvider privateSecurityContextProvider;
    private String anonymousTokenName;
    private String privateTokenName;

    public AccessController(SecurityContextProvider anonymousSecurityContextProvider, SecurityContextProvider privateSecurityContextProvider, String anymousTokenName, String privateTokenName) {
        this.anonymousSecurityContextProvider = anonymousSecurityContextProvider;
        this.privateSecurityContextProvider = privateSecurityContextProvider;
        this.anonymousTokenName = anymousTokenName;
        this.privateTokenName = privateTokenName;
    }

    public void handshake(AccessControlType accessControlType, TokenExtractionMode tokenExtractionMode) {
        if (!accessControlType.equals((Object)AccessControlType.PUBLIC)) {
            if (accessControlType.equals((Object)AccessControlType.ANONYMOUS)) {
                String token = this.extractToken(this.anonymousTokenName, tokenExtractionMode);
                this.anonymousSecurityContextProvider.provideSecurityContext(token);
            } else {
                String token = this.extractToken(this.privateTokenName, tokenExtractionMode);
                this.privateSecurityContextProvider.provideSecurityContext(token);
            }
        }
    }

    private String extractToken(String key, TokenExtractionMode tokenExtractionMode) {
        String result = TokenExtractorFactory.getTokenExtractor(tokenExtractionMode).extractToken(key);
        return result;
    }
}

