/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.security.tokens.encoder.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.sklsft.commons.crypto.accessors.AesKeyAccessor;
import org.sklsft.commons.crypto.encoding.AesJsonObjectEncoder;
import org.sklsft.commons.crypto.encoding.ObjectEncoder;
import org.sklsft.commons.rest.security.exception.InvalidTokenException;
import org.sklsft.commons.rest.security.tokens.encoder.TokenEncoder;

public class AesJsonTokenEncoder<T>
implements TokenEncoder<T> {
    private ObjectEncoder objectEncoder;
    private Class<T> tokenClass;

    public AesJsonTokenEncoder(ObjectMapper objectMapper, AesKeyAccessor keyAccessor, Class<T> tokenClass) {
        this.objectEncoder = new AesJsonObjectEncoder(objectMapper, keyAccessor);
        this.tokenClass = tokenClass;
    }

    @Override
    public T decode(String token) {
        try {
            return (T)this.objectEncoder.decode(token, this.tokenClass);
        }
        catch (Exception e) {
            throw new InvalidTokenException("token.invalid", e);
        }
    }

    @Override
    public String encode(T token) {
        return this.objectEncoder.encode(token);
    }
}

