/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.security.tokens.encoder.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.sklsft.commons.rest.security.exception.InvalidTokenException;
import org.sklsft.commons.rest.security.exception.TokenEncodingException;
import org.sklsft.commons.rest.security.tokens.encoder.TokenEncoder;
import org.sklsft.commons.rest.security.tokens.jwt.JsonWebToken;

public abstract class JwtEncoder<H, B>
implements TokenEncoder<JsonWebToken<H, B>> {
    private ObjectMapper objectMapper;
    private Class<H> headerClass;
    private Class<B> bodyClass;

    public JwtEncoder(ObjectMapper objectMapper, Class<H> headerClass, Class<B> bodyClass) {
        this.objectMapper = objectMapper;
        this.headerClass = headerClass;
        this.bodyClass = bodyClass;
    }

    @Override
    public JsonWebToken<H, B> decode(String token) {
        String[] parts = token.split("\\.");
        JsonWebToken<Object, Object> result = new JsonWebToken<Object, Object>();
        try {
            result.setHeader(this.objectMapper.readValue(Base64.decodeBase64((String)parts[0]), this.headerClass));
            result.setBody(this.objectMapper.readValue(Base64.decodeBase64((String)parts[1]), this.bodyClass));
            result.setSignature(Base64.decodeBase64((String)parts[2]));
            result.setPayload((parts[0] + "." + parts[1]).getBytes(StandardCharsets.UTF_8));
            return result;
        }
        catch (IOException e) {
            throw new InvalidTokenException(e.getMessage(), e);
        }
    }

    @Override
    public String encode(JsonWebToken<H, B> token) {
        String result = "";
        String headerPart = "";
        String bodyPart = "";
        byte[] payload = null;
        String signaturePart = "";
        try {
            headerPart = headerPart + Base64.encodeBase64URLSafeString((byte[])this.objectMapper.writeValueAsBytes(token.getHeader()));
            bodyPart = bodyPart + Base64.encodeBase64URLSafeString((byte[])this.objectMapper.writeValueAsBytes(token.getBody()));
            result = headerPart + "." + bodyPart;
            payload = result.getBytes(StandardCharsets.UTF_8);
            signaturePart = Base64.encodeBase64URLSafeString((byte[])this.sign(payload));
            result = result + "." + signaturePart;
        }
        catch (JsonProcessingException e) {
            throw new TokenEncodingException("Failed to encode token", e);
        }
        return result;
    }

    protected abstract byte[] sign(byte[] var1);
}

