/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.security.context.impl;

import org.sklsft.commons.rest.security.context.impl.BasicSecurityContextProvider;
import org.sklsft.commons.rest.security.credentials.extractor.SecurityCredentialsExtractor;
import org.sklsft.commons.rest.security.credentials.validator.SecurityCredentialsValidator;
import org.sklsft.commons.rest.security.tokens.encoder.TokenEncoder;
import org.sklsft.commons.rest.security.tokens.verification.TokenVerifier;

public class FromSignedTokenSecurityContextProvider<T, C>
extends BasicSecurityContextProvider<C> {
    private TokenEncoder<T> tokenEncoder;
    private TokenVerifier<T> tokenVerifier;
    private SecurityCredentialsExtractor<T, C> credentialsExtractor;
    private SecurityCredentialsValidator<C> credentialsValidator;

    public FromSignedTokenSecurityContextProvider(TokenEncoder<T> tokenEncoder, TokenVerifier<T> tokenVerifier, SecurityCredentialsExtractor<T, C> credentialsExtractor, SecurityCredentialsValidator<C> credentialsValidator) {
        this.tokenEncoder = tokenEncoder;
        this.tokenVerifier = tokenVerifier;
        this.credentialsExtractor = credentialsExtractor;
        this.credentialsValidator = credentialsValidator;
    }

    @Override
    protected C getValidCredentials(String token) {
        T tokenObject = this.tokenEncoder.decode(token);
        this.tokenVerifier.verifyToken(tokenObject);
        C credentials = this.credentialsExtractor.getCredentials(tokenObject);
        this.credentialsValidator.validateCredentials(credentials);
        return credentials;
    }
}

