/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.security.context.impl;

import org.sklsft.commons.rest.security.context.impl.BasicSecurityContextProvider;
import org.sklsft.commons.rest.security.credentials.extractor.SecurityContextExtractor;
import org.sklsft.commons.rest.security.credentials.validator.SecurityContextValidator;
import org.sklsft.commons.rest.security.tokens.encoder.TokenDecoder;
import org.sklsft.commons.rest.security.tokens.verification.TokenVerifier;

public class FromSignedTokenSecurityContextProvider<T, C>
extends BasicSecurityContextProvider<C> {
    private TokenDecoder<T> tokenDecoder;
    private TokenVerifier<T> tokenVerifier;
    private SecurityContextExtractor<T, C> contextExtractor;
    private SecurityContextValidator<C> contextValidator;

    public FromSignedTokenSecurityContextProvider(TokenDecoder<T> tokenDecoder, TokenVerifier<T> tokenVerifier, SecurityContextExtractor<T, C> contextExtractor, SecurityContextValidator<C> contextValidator) {
        this.tokenDecoder = tokenDecoder;
        this.tokenVerifier = tokenVerifier;
        this.contextExtractor = contextExtractor;
        this.contextValidator = contextValidator;
    }

    @Override
    protected C getValidContext(String token) {
        T tokenObject = this.tokenDecoder.decode(token);
        this.tokenVerifier.verifyToken(tokenObject);
        C context = this.contextExtractor.extractContext(tokenObject);
        this.contextValidator.validateContext(context);
        return context;
    }
}

