/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.security.tokens.encoder.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.sklsft.commons.rest.security.exception.TokenEncodingException;
import org.sklsft.commons.rest.security.tokens.encoder.TokenEncoder;
import org.sklsft.commons.rest.security.tokens.jwt.JsonWebToken;

public abstract class JwtEncoder<T extends JsonWebToken>
implements TokenEncoder<T> {
    private ObjectMapper objectMapper;

    public JwtEncoder(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public String encode(T token) {
        Object result = "";
        Object headerPart = "";
        Object bodyPart = "";
        byte[] payload = null;
        String signaturePart = "";
        try {
            headerPart = (String)headerPart + Base64.encodeBase64URLSafeString((byte[])this.objectMapper.writeValueAsBytes(((JsonWebToken)token).getHeader()));
            bodyPart = (String)bodyPart + Base64.encodeBase64URLSafeString((byte[])this.objectMapper.writeValueAsBytes(((JsonWebToken)token).getBody()));
            result = (String)headerPart + "." + (String)bodyPart;
            payload = ((String)result).getBytes(StandardCharsets.UTF_8);
            signaturePart = Base64.encodeBase64URLSafeString((byte[])this.sign(payload));
            result = (String)result + "." + signaturePart;
        }
        catch (JsonProcessingException e) {
            throw new TokenEncodingException("Failed to encode token", e);
        }
        return result;
    }

    protected abstract byte[] sign(byte[] var1);
}

