/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.security.tokens.extraction.impl;

import jakarta.servlet.http.Cookie;
import org.sklsft.commons.rest.security.tokens.extraction.TokenExtractor;
import org.sklsft.commons.rest.security.tokens.extraction.impl.TokenFromHeaderExtractor;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class TokenFromCookieExtractor
implements TokenExtractor {
    private TokenFromHeaderExtractor tokenFromHeaderExtractor;

    public TokenFromCookieExtractor(TokenFromHeaderExtractor tokenFromHeaderExtractor) {
        this.tokenFromHeaderExtractor = tokenFromHeaderExtractor;
    }

    @Override
    public String extractToken(String key) {
        String result = this.tokenFromHeaderExtractor.extractToken(key);
        if (result != null) {
            return result;
        }
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        Cookie[] cookies = servletRequestAttributes.getRequest().getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(key)) continue;
                result = cookie.getValue();
                return result;
            }
        }
        return result;
    }
}

