/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.aspect;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.sklsft.commons.rest.aspect.RestRequestContext;
import org.sklsft.commons.rest.aspect.RestRequestContextHolder;
import org.sklsft.commons.rest.security.context.SecurityContextHolder;
import org.springframework.core.annotation.Order;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Order(value=0)
public class RestRequestAspect {
    @Around(value="@annotation(org.springframework.web.bind.annotation.RequestMapping)")
    public Object handle(ProceedingJoinPoint joinPoint) throws Throwable {
        String requestId = this.getHeader("request-id");
        RestRequestContextHolder.bind(new RestRequestContext(requestId));
        try {
            Object object = joinPoint.proceed();
            return object;
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            SecurityContextHolder.unbindCredentials();
        }
    }

    private String getHeader(String key) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        String result = servletRequestAttributes.getRequest().getHeader(key);
        return result;
    }
}

