/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.aspect.correlation;

import java.util.UUID;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.sklsft.commons.api.context.RequestContext;
import org.springframework.core.annotation.Order;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Order(value=0)
public class RestRequestAspect {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(org.springframework.web.bind.annotation.RequestMapping)")
    public Object handle(ProceedingJoinPoint joinPoint) throws Throwable {
        String transactionId = UUID.randomUUID().toString();
        String correlationId = this.getHeader("correlation-id");
        if (correlationId == null) {
            correlationId = transactionId;
        }
        org.sklsft.commons.api.context.RequestContextHolder.bind((RequestContext)new RequestContext(transactionId, correlationId, "HTTP REST"));
        try {
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            org.sklsft.commons.api.context.RequestContextHolder.unbind();
        }
    }

    private String getHeader(String key) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        String result = servletRequestAttributes.getRequest().getHeader(key);
        return result;
    }
}

