/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.aspect.logging;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.sklsft.commons.api.exception.ApplicationException;
import org.sklsft.commons.log.AccessLogger;
import org.sklsft.commons.log.ErrorLogger;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Order(value=2)
public class RestLoggingAspect {
    private AccessLogger accessLogger;
    private ErrorLogger errorLogger;
    private boolean traceRequestBody;
    private boolean traceResponseBody;

    public void setAccessLogger(AccessLogger accessLogger) {
        this.accessLogger = accessLogger;
    }

    public void setErrorLogger(ErrorLogger errorLogger) {
        this.errorLogger = errorLogger;
    }

    public void setTraceRequestBody(boolean traceRequestBody) {
        this.traceRequestBody = traceRequestBody;
    }

    public void setTraceResponseBody(boolean traceResponseBody) {
        this.traceResponseBody = traceResponseBody;
    }

    @Around(value="@annotation(org.springframework.web.bind.annotation.RequestMapping) || @annotation(org.springframework.web.bind.annotation.GetMapping) || @annotation(org.springframework.web.bind.annotation.PostMapping) || @annotation(org.springframework.web.bind.annotation.PutMapping) || @annotation(org.springframework.web.bind.annotation.PatchMapping) || @annotation(org.springframework.web.bind.annotation.DeleteMapping)")
    public Object handleLogging(ProceedingJoinPoint joinPoint) throws Throwable {
        long start = System.currentTimeMillis();
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        String transactionType = this.getTransactionType(request, joinPoint);
        Object body = null;
        if (this.traceRequestBody) {
            body = this.getRequestBody(joinPoint);
        }
        this.accessLogger.logRequest(transactionType, body);
        try {
            Object proceed = joinPoint.proceed();
            long elapsedTime = System.currentTimeMillis() - start;
            Object responseBody = null;
            if (this.traceResponseBody) {
                responseBody = proceed;
            }
            this.accessLogger.logResponse(transactionType, responseBody, Long.valueOf(elapsedTime), "200", "OK");
            return proceed;
        }
        catch (ApplicationException e) {
            long elapsedTime = System.currentTimeMillis() - start;
            this.accessLogger.logResponse(transactionType, null, Long.valueOf(elapsedTime), e.getHttpErrorCode(), e.getMessage());
            this.errorLogger.logApplicationException(e);
            throw e;
        }
        catch (Exception e) {
            long elapsedTime = System.currentTimeMillis() - start;
            this.accessLogger.logResponse(transactionType, null, Long.valueOf(elapsedTime), "500", e.getMessage());
            this.errorLogger.logException(e);
            throw e;
        }
    }

    private String getTransactionType(HttpServletRequest request, ProceedingJoinPoint joinPoint) {
        String result = request.getMethod();
        result = result + " " + request.getRequestURI();
        return result;
    }

    private Object getRequestBody(ProceedingJoinPoint joinPoint) {
        Method proxiedMethod = ((MethodSignature)joinPoint.getSignature()).getMethod();
        Object[] args = joinPoint.getArgs();
        Annotation[][] paramsAnnotations = proxiedMethod.getParameterAnnotations();
        for (int i = 0; i < args.length; ++i) {
            for (int j = 0; j < paramsAnnotations[i].length; ++j) {
                if (!paramsAnnotations[i][j].annotationType().equals(RequestBody.class)) continue;
                return args[i];
            }
        }
        return null;
    }
}

