/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.exception;

import org.sklsft.commons.api.exception.ApplicationException;
import org.sklsft.commons.api.exception.ErrorReport;
import org.sklsft.commons.api.exception.TechnicalError;
import org.sklsft.commons.api.exception.rights.AccessDeniedException;
import org.sklsft.commons.api.exception.rights.OperationDeniedException;
import org.sklsft.commons.api.exception.validation.InvalidArgumentException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class RestExceptionHandler {
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={AccessDeniedException.class})
    @ResponseBody
    public ErrorReport handleApplicationException(AccessDeniedException e) {
        ErrorReport errorReport = new ErrorReport();
        errorReport.setExceptionClassName(e.getClass().getName());
        errorReport.setMessage(e.getMessage());
        errorReport.setDetails(e.getDetails());
        return errorReport;
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={OperationDeniedException.class})
    @ResponseBody
    public ErrorReport handleApplicationException(OperationDeniedException e) {
        ErrorReport errorReport = new ErrorReport();
        errorReport.setExceptionClassName(e.getClass().getName());
        errorReport.setMessage(e.getMessage());
        errorReport.setDetails(e.getDetails());
        return errorReport;
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={ApplicationException.class})
    @ResponseBody
    public ErrorReport handleApplicationException(ApplicationException e) {
        ErrorReport errorReport = new ErrorReport();
        errorReport.setExceptionClassName(e.getClass().getName());
        errorReport.setMessage(e.getMessage());
        errorReport.setDetails(e.getDetails());
        return errorReport;
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ErrorReport handleException(Exception e) {
        ErrorReport errorReport = new ErrorReport();
        errorReport.setExceptionClassName(TechnicalError.class.getName());
        errorReport.setMessage("error.unknown");
        return errorReport;
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public ErrorReport handleException(MethodArgumentNotValidException e) {
        ErrorReport errorReport = new ErrorReport();
        errorReport.setExceptionClassName(InvalidArgumentException.class.getName());
        errorReport.setMessage("invalid.arguments");
        return errorReport;
    }
}

