/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.aspect.logging;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.sklsft.commons.aop.AspectJUtils;
import org.sklsft.commons.log.aspects.LoggingAspectTemplate;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Order(value=2)
public class RestLoggingAspect
extends LoggingAspectTemplate {
    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.RequestMapping) || @annotation(org.springframework.web.bind.annotation.GetMapping) || @annotation(org.springframework.web.bind.annotation.PostMapping) || @annotation(org.springframework.web.bind.annotation.PutMapping) || @annotation(org.springframework.web.bind.annotation.PatchMapping) || @annotation(org.springframework.web.bind.annotation.DeleteMapping)")
    protected void onPointcut() {
    }

    protected Object getRequestBody(ProceedingJoinPoint joinPoint) {
        Method proxiedMethod = AspectJUtils.getProxiedMethodImplementation((ProceedingJoinPoint)joinPoint);
        Object[] args = joinPoint.getArgs();
        Annotation[][] paramsAnnotations = proxiedMethod.getParameterAnnotations();
        for (int i = 0; i < args.length; ++i) {
            for (int j = 0; j < paramsAnnotations[i].length; ++j) {
                if (!paramsAnnotations[i][j].annotationType().equals(RequestBody.class)) continue;
                return args[i];
            }
        }
        return null;
    }

    protected String getFallbackTransactionType(Method proxiedMethod) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        Object result = request.getMethod();
        result = (String)result + " " + request.getRequestURI();
        return result;
    }
}

