/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.exception;

import org.sklsft.commons.api.exception.ApplicationException;
import org.sklsft.commons.api.exception.ErrorReport;
import org.sklsft.commons.api.exception.TechnicalError;
import org.sklsft.commons.api.exception.repository.ObjectNotFoundException;
import org.sklsft.commons.api.exception.rights.AccessDeniedException;
import org.sklsft.commons.api.exception.validation.InvalidArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class RestExceptionHandler {
    private static final Logger classLogger = LoggerFactory.getLogger(RestExceptionHandler.class);
    private boolean printErrorStackInRootLogger = true;

    public void setPrintErrorStackInRootLogger(boolean printErrorStackInRootLogger) {
        this.printErrorStackInRootLogger = printErrorStackInRootLogger;
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={AccessDeniedException.class})
    @ResponseBody
    public ErrorReport handleApplicationException(AccessDeniedException e) {
        if (this.printErrorStackInRootLogger) {
            classLogger.error(e.getMessage(), (Throwable)e);
        }
        ErrorReport errorReport = new ErrorReport();
        errorReport.setExceptionClassName(e.getClass().getName());
        errorReport.setMessage(e.getMessage());
        return errorReport;
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={org.springframework.security.access.AccessDeniedException.class})
    @ResponseBody
    public ErrorReport handleApplicationException(org.springframework.security.access.AccessDeniedException e) {
        if (this.printErrorStackInRootLogger) {
            classLogger.error(e.getMessage(), (Throwable)e);
        }
        ErrorReport errorReport = new ErrorReport();
        errorReport.setExceptionClassName(AccessDeniedException.class.getName());
        errorReport.setMessage("access.denied");
        return errorReport;
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={ObjectNotFoundException.class})
    @ResponseBody
    public ErrorReport handleApplicationException(ObjectNotFoundException e) {
        if (this.printErrorStackInRootLogger) {
            classLogger.error(e.getMessage(), (Throwable)e);
        }
        ErrorReport errorReport = new ErrorReport();
        errorReport.setExceptionClassName(e.getClass().getName());
        errorReport.setMessage(e.getMessage());
        return errorReport;
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={ApplicationException.class})
    @ResponseBody
    public ErrorReport handleApplicationException(ApplicationException e) {
        if (this.printErrorStackInRootLogger) {
            classLogger.error(e.getMessage(), (Throwable)e);
        }
        ErrorReport errorReport = new ErrorReport();
        errorReport.setExceptionClassName(e.getClass().getName());
        errorReport.setMessage(e.getMessage());
        return errorReport;
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ErrorReport handleException(Exception e) {
        if (this.printErrorStackInRootLogger) {
            classLogger.error(e.getMessage(), (Throwable)e);
        }
        ErrorReport errorReport = new ErrorReport();
        errorReport.setExceptionClassName(TechnicalError.class.getName());
        errorReport.setMessage("error.unknown");
        return errorReport;
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public ErrorReport handleException(MethodArgumentNotValidException e) {
        if (this.printErrorStackInRootLogger) {
            classLogger.error(e.getMessage(), (Throwable)e);
        }
        ErrorReport errorReport = new ErrorReport();
        errorReport.setExceptionClassName(InvalidArgumentException.class.getName());
        errorReport.setMessage("invalid.arguments");
        return errorReport;
    }
}

