/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bl.services.impl;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.sklsft.generator.exception.InvalidFileException;
import org.sklsft.generator.model.om.Project;
import org.sklsft.generator.model.om.Table;
import org.sklsft.generator.repository.dao.jdbc.impl.JdbcRawCommand;
import org.sklsft.generator.repository.file.impl.SimpleScriptFileReaderImpl;
import org.sklsft.generator.repository.file.interfaces.SimpleScriptFileReader;

public class TableBuilder {
    private Table table;
    private DataSource dataSource;
    private SimpleScriptFileReader scriptFileReader;
    private int step;

    public TableBuilder(Table table, DataSource dataSource, int step) {
        this.table = table;
        this.dataSource = dataSource;
        this.scriptFileReader = new SimpleScriptFileReaderImpl();
        this.step = step;
    }

    public void buildTable() throws IOException, InvalidFileException, SQLException {
        String scriptFilePath = this.table.myPackage.model.project.sourceFolder + File.separator + Project.BUILD_SCRIPT_FOLDER + File.separator + this.step + File.separator + this.table.myPackage.name + File.separator + this.table.originalName + ".sql";
        String script = this.scriptFileReader.readScript(scriptFilePath);
        new JdbcRawCommand(this.dataSource, script).execute();
    }
}

