/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.jsonassert;

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONString;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.skyscreamer.jsonassert.JSONParser;
import org.skyscreamer.jsonassert.comparator.DefaultComparator;
import org.skyscreamer.jsonassert.comparator.JSONComparator;

public final class JSONCompare {
    private JSONCompare() {
    }

    private static JSONComparator getComparatorForMode(JSONCompareMode mode) {
        return new DefaultComparator(mode);
    }

    public static JSONCompareResult compareJSON(String expectedStr, String actualStr, JSONComparator comparator) {
        Object expected = JSONParser.parseJSON(expectedStr);
        Object actual = JSONParser.parseJSON(actualStr);
        if (expected instanceof JSONObject && actual instanceof JSONObject) {
            return JSONCompare.compareJSON((JSONObject)expected, (JSONObject)actual, comparator);
        }
        if (expected instanceof JSONArray && actual instanceof JSONArray) {
            return JSONCompare.compareJSON((JSONArray)expected, (JSONArray)actual, comparator);
        }
        if (expected instanceof JSONString && actual instanceof JSONString) {
            return JSONCompare.compareJson((JSONString)expected, (JSONString)actual);
        }
        if (expected instanceof JSONObject) {
            return new JSONCompareResult().fail("", expected, actual);
        }
        return new JSONCompareResult().fail("", expected, actual);
    }

    public static JSONCompareResult compareJSON(JSONObject expected, JSONObject actual, JSONComparator comparator) {
        return comparator.compareJSON(expected, actual);
    }

    public static JSONCompareResult compareJSON(JSONArray expected, JSONArray actual, JSONComparator comparator) {
        return comparator.compareJSON(expected, actual);
    }

    public static JSONCompareResult compareJson(JSONString expected, JSONString actual) {
        String actualJson;
        JSONCompareResult result = new JSONCompareResult();
        String expectedJson = expected.toJSONString();
        if (!expectedJson.equals(actualJson = actual.toJSONString())) {
            result.fail("");
        }
        return result;
    }

    public static JSONCompareResult compareJSON(String expectedStr, String actualStr, JSONCompareMode mode) {
        return JSONCompare.compareJSON(expectedStr, actualStr, JSONCompare.getComparatorForMode(mode));
    }

    public static JSONCompareResult compareJSON(JSONObject expected, JSONObject actual, JSONCompareMode mode) {
        return JSONCompare.compareJSON(expected, actual, JSONCompare.getComparatorForMode(mode));
    }

    public static JSONCompareResult compareJSON(JSONArray expected, JSONArray actual, JSONCompareMode mode) {
        return JSONCompare.compareJSON(expected, actual, JSONCompare.getComparatorForMode(mode));
    }
}

