/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.jsonassert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.skyscreamer.jsonassert.FieldComparisonFailure;
import org.skyscreamer.jsonassert.ValueMatcherException;

public class JSONCompareResult {
    private boolean _success;
    private StringBuilder _message;
    private String _field;
    private Object _expected;
    private Object _actual;
    private final List<FieldComparisonFailure> _fieldFailures = new ArrayList<FieldComparisonFailure>();
    private final List<FieldComparisonFailure> _fieldMissing = new ArrayList<FieldComparisonFailure>();
    private final List<FieldComparisonFailure> _fieldUnexpected = new ArrayList<FieldComparisonFailure>();

    public JSONCompareResult() {
        this(true, null);
    }

    private JSONCompareResult(boolean success, String message) {
        this._success = success;
        this._message = new StringBuilder(message == null ? "" : message);
    }

    public boolean passed() {
        return this._success;
    }

    public boolean failed() {
        return !this._success;
    }

    public String getMessage() {
        return this._message.toString();
    }

    public List<FieldComparisonFailure> getFieldFailures() {
        return Collections.unmodifiableList(this._fieldFailures);
    }

    public List<FieldComparisonFailure> getFieldMissing() {
        return Collections.unmodifiableList(this._fieldMissing);
    }

    public List<FieldComparisonFailure> getFieldUnexpected() {
        return Collections.unmodifiableList(this._fieldUnexpected);
    }

    @Deprecated
    public Object getActual() {
        return this._actual;
    }

    @Deprecated
    public Object getExpected() {
        return this._expected;
    }

    public boolean isFailureOnField() {
        return !this._fieldFailures.isEmpty();
    }

    public boolean isMissingOnField() {
        return !this._fieldMissing.isEmpty();
    }

    public boolean isUnexpectedOnField() {
        return !this._fieldUnexpected.isEmpty();
    }

    @Deprecated
    public String getField() {
        return this._field;
    }

    public void fail(String message) {
        this._success = false;
        if (this._message.length() == 0) {
            this._message.append(message);
        } else {
            this._message.append(" ; ").append(message);
        }
    }

    public JSONCompareResult fail(String field, Object expected, Object actual) {
        this._fieldFailures.add(new FieldComparisonFailure(field, expected, actual));
        this._field = field;
        this._expected = expected;
        this._actual = actual;
        this.fail(this.formatFailureMessage(field, expected, actual));
        return this;
    }

    public JSONCompareResult fail(String field, ValueMatcherException exception) {
        this.fail(field + ": " + exception.getMessage(), exception.getExpected(), exception.getActual());
        return this;
    }

    private String formatFailureMessage(String field, Object expected, Object actual) {
        return field + "\nExpected: " + JSONCompareResult.describe(expected) + "\n     got: " + JSONCompareResult.describe(actual) + "\n";
    }

    public JSONCompareResult missing(String field, Object expected) {
        this._fieldMissing.add(new FieldComparisonFailure(field, expected, null));
        this.fail(this.formatMissing(field, expected));
        return this;
    }

    private String formatMissing(String field, Object expected) {
        return field + "\nExpected: " + JSONCompareResult.describe(expected) + "\n     but none found\n";
    }

    public JSONCompareResult unexpected(String field, Object actual) {
        this._fieldUnexpected.add(new FieldComparisonFailure(field, null, actual));
        this.fail(this.formatUnexpected(field, actual));
        return this;
    }

    private String formatUnexpected(String field, Object actual) {
        return field + "\nUnexpected: " + JSONCompareResult.describe(actual) + "\n";
    }

    private static String describe(Object value) {
        if (value instanceof JSONArray) {
            return "a JSON array";
        }
        if (value instanceof JSONObject) {
            return "a JSON object";
        }
        return String.valueOf(value);
    }

    public String toString() {
        return this._message.toString();
    }
}

