/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms;

import java.io.Serializable;
import javax.jms.ConnectionFactory;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.apache.commons.lang.StringUtils;
import org.skyscreamer.nevado.jms.NevadoConnection;
import org.skyscreamer.nevado.jms.NevadoQueueConnection;
import org.skyscreamer.nevado.jms.NevadoTopicConnection;
import org.skyscreamer.nevado.jms.connector.SQSConnectorFactory;
import org.skyscreamer.nevado.jms.resource.NevadoReferencableFactory;
import org.springframework.beans.factory.annotation.Required;

public class NevadoConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
Serializable,
Referenceable {
    public static final String JNDI_AWS_ACCESS_KEY = "awsAccessKey";
    public static final String JNDI_AWS_SECRET_KEY = "awsSecretKey";
    public static final String JNDI_CLIENT_ID = "clientID";
    public static final String JNDI_JMS_DELIVERY_MODE = "jmsDeliveryMode";
    public static final String JNDI_JMS_TTL = "jmsTTL";
    public static final String JNDI_JMS_PRIORITY = "jmsPriority";
    private SQSConnectorFactory _sqsConnectorFactory;
    private volatile String _awsAccessKey;
    private volatile String _awsSecretKey;
    private volatile String _clientID;
    private volatile Integer _jmsDeliveryMode;
    private volatile Long _jmsTTL;
    private volatile Integer _jmsPriority;

    public NevadoConnectionFactory() {
    }

    public NevadoConnectionFactory(SQSConnectorFactory sqsConnectorFactory) {
        this._sqsConnectorFactory = sqsConnectorFactory;
    }

    public NevadoQueueConnection createQueueConnection() throws JMSException {
        this.checkSQSConnectorFactory();
        NevadoQueueConnection connection = new NevadoQueueConnection(this._sqsConnectorFactory.getInstance(this._awsAccessKey, this._awsSecretKey));
        this.initializeConnection(connection);
        return connection;
    }

    public NevadoQueueConnection createQueueConnection(String awsAccessKey, String awsSecretKey) throws JMSException {
        this.checkSQSConnectorFactory();
        NevadoQueueConnection connection = new NevadoQueueConnection(this._sqsConnectorFactory.getInstance(awsAccessKey, awsSecretKey));
        this.initializeConnection(connection);
        return connection;
    }

    public NevadoConnection createConnection() throws JMSException {
        this.checkSQSConnectorFactory();
        NevadoConnection connection = new NevadoConnection(this._sqsConnectorFactory.getInstance(this._awsAccessKey, this._awsSecretKey));
        this.initializeConnection(connection);
        return connection;
    }

    public NevadoConnection createConnection(String awsAccessKey, String awsSecretKey) throws JMSException {
        this.checkSQSConnectorFactory();
        NevadoConnection connection = new NevadoConnection(this._sqsConnectorFactory.getInstance(awsAccessKey, awsSecretKey));
        this.initializeConnection(connection);
        return connection;
    }

    public NevadoTopicConnection createTopicConnection() throws JMSException {
        this.checkSQSConnectorFactory();
        NevadoTopicConnection connection = new NevadoTopicConnection(this._sqsConnectorFactory.getInstance(this._awsAccessKey, this._awsSecretKey));
        this.initializeConnection(connection);
        return connection;
    }

    public TopicConnection createTopicConnection(String awsAccessKey, String awsSecretKey) throws JMSException {
        this.checkSQSConnectorFactory();
        NevadoTopicConnection connection = new NevadoTopicConnection(this._sqsConnectorFactory.getInstance(awsAccessKey, awsSecretKey));
        this.initializeConnection(connection);
        return connection;
    }

    private void initializeConnection(NevadoConnection connection) throws JMSException {
        if (StringUtils.isNotEmpty((String)this._clientID)) {
            connection.setClientID(this._clientID);
        }
        connection.setOverrideJMSDeliveryMode(this._jmsDeliveryMode);
        connection.setOverrideJMSPriority(this._jmsPriority);
        connection.setOverrideJMSTTL(this._jmsTTL);
    }

    @Required
    public void setSqsConnectorFactory(SQSConnectorFactory sqsConnectorFactory) {
        this._sqsConnectorFactory = sqsConnectorFactory;
    }

    public void setAwsAccessKey(String awsAccessKey) {
        this._awsAccessKey = awsAccessKey;
    }

    public void setAwsSecretKey(String awsSecretKey) {
        this._awsSecretKey = awsSecretKey;
    }

    public void setClientID(String clientID) {
        this._clientID = clientID;
    }

    public void setOverrideJMSDeliveryMode(Integer jmsDeliveryMode) {
        this._jmsDeliveryMode = jmsDeliveryMode;
    }

    public void setOverrideJMSTTL(Long jmsTTL) {
        this._jmsTTL = jmsTTL;
    }

    public void setOverrideJMSPriority(Integer jmsPriority) {
        this._jmsPriority = jmsPriority;
    }

    public String getAwsAccessKey() {
        return this._awsAccessKey;
    }

    public String getAwsSecretKey() {
        return this._awsSecretKey;
    }

    public String getClientID() {
        return this._clientID;
    }

    public Integer getJMSDeliveryMode() {
        return this._jmsDeliveryMode;
    }

    public Long getJMSTTL() {
        return this._jmsTTL;
    }

    public Integer getJMSPriority() {
        return this._jmsPriority;
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = new Reference(NevadoConnectionFactory.class.getName(), new StringRefAddr(JNDI_AWS_ACCESS_KEY, this._awsAccessKey), NevadoReferencableFactory.class.getName(), null);
        reference.add(new StringRefAddr(JNDI_AWS_SECRET_KEY, this._awsSecretKey));
        if (this._clientID != null) {
            reference.add(new StringRefAddr(JNDI_CLIENT_ID, this._clientID));
        }
        if (this._jmsDeliveryMode != null) {
            reference.add(new StringRefAddr(JNDI_JMS_DELIVERY_MODE, this._jmsDeliveryMode.toString()));
        }
        if (this._jmsTTL != null) {
            reference.add(new StringRefAddr(JNDI_JMS_TTL, this._jmsTTL.toString()));
        }
        if (this._jmsPriority != null) {
            reference.add(new StringRefAddr(JNDI_JMS_PRIORITY, this._jmsPriority.toString()));
        }
        return reference;
    }

    private void checkSQSConnectorFactory() throws IllegalStateException {
        if (this._sqsConnectorFactory == null) {
            throw new IllegalStateException("SQSConnectorFactory is null, it must be set.");
        }
    }
}

