/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms.connector.typica;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.skyscreamer.nevado.jms.connector.SQSConnector;
import org.skyscreamer.nevado.jms.connector.SQSConnectorFactory;
import org.skyscreamer.nevado.jms.connector.typica.TypicaSQSConnector;

public class TypicaSQSConnectorFactory
implements SQSConnectorFactory {
    private final Log _log = LogFactory.getLog(this.getClass());
    public static final int DEFAULT_RECEIVE_CHECK_INTERVAL_MS = 200;
    private boolean _isSecure = true;
    private long _receiveCheckIntervalMs = 200L;

    @Override
    public SQSConnector getInstance(String awsAccessKey, String awsSecretKey) {
        TypicaSQSConnector typicaSQSConnector = new TypicaSQSConnector(awsAccessKey, awsSecretKey, this._isSecure, this._receiveCheckIntervalMs);
        return typicaSQSConnector;
    }

    public void setSecure(boolean secure) {
        this._isSecure = secure;
    }

    public void setReceiveCheckIntervalMs(long receiveCheckIntervalMs) {
        if (receiveCheckIntervalMs < 200L) {
            this._log.warn((Object)"Reducing the receiveCheckInterval will increase your AWS costs.  Amazon charges each time a check is made, even if no message is available: http://aws.amazon.com/sqs/pricing/");
        }
        this._receiveCheckIntervalMs = receiveCheckIntervalMs;
    }
}

