/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms;

import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.skyscreamer.nevado.jms.NevadoConnection;
import org.skyscreamer.nevado.jms.NevadoMessageConsumer;
import org.skyscreamer.nevado.jms.NevadoMessageProducer;
import org.skyscreamer.nevado.jms.NevadoSession;
import org.skyscreamer.nevado.jms.destination.NevadoTemporaryTopic;
import org.skyscreamer.nevado.jms.destination.NevadoTopic;

public class NevadoQueueSession
extends NevadoSession
implements QueueSession {
    protected NevadoQueueSession(NevadoConnection connection, boolean transacted, int acknowledgeMode) {
        super(connection, transacted, acknowledgeMode);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        this.checkClosed();
        return this.createConsumer((Destination)queue);
    }

    public QueueReceiver createReceiver(Queue queue, String selector) throws JMSException {
        this.checkClosed();
        return this.createConsumer((Destination)queue, selector);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        this.checkClosed();
        return this.createProducer((Destination)queue);
    }

    @Override
    public NevadoMessageProducer createProducer(Destination destination) throws JMSException {
        this.checkIsQueue(destination);
        return super.createProducer(destination);
    }

    @Override
    public NevadoMessageConsumer createConsumer(Destination destination) throws JMSException {
        this.checkIsQueue(destination);
        return super.createConsumer(destination);
    }

    @Override
    public NevadoMessageConsumer createConsumer(Destination destination, String selector) throws JMSException {
        this.checkIsQueue(destination);
        return super.createConsumer(destination, selector);
    }

    @Override
    public NevadoMessageConsumer createConsumer(Destination destination, String selector, boolean noLocal) throws JMSException {
        this.checkIsQueue(destination);
        return super.createConsumer(destination, selector, noLocal);
    }

    private void checkIsQueue(Destination destination) throws IllegalStateException {
        if (!(destination instanceof Queue)) {
            throw new IllegalStateException("QueueSession does not handle destinations of type " + destination.getClass().getName());
        }
    }

    @Override
    public NevadoTopic createTopic(String s) throws JMSException {
        throw new IllegalStateException("QueueSession will not perform topic operations");
    }

    @Override
    public NevadoTemporaryTopic createTemporaryTopic() throws JMSException {
        throw new IllegalStateException("QueueSession will not perform topic operations");
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String s, String s1, boolean b) throws JMSException {
        throw new IllegalStateException("QueueSession will not perform topic operations");
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String s) throws JMSException {
        throw new IllegalStateException("QueueSession will not perform topic operations");
    }

    @Override
    public void unsubscribe(String s) throws JMSException {
        throw new IllegalStateException("QueueSession will not perform topic operations");
    }
}

