/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BackoffSleeper {
    private final Log _log = LogFactory.getLog(this.getClass());
    private volatile long _wait;
    private final long _minWait;
    private final long _maxWait;
    private final double _backoffMultiplier;
    private final Object _waiter = new Object();

    public BackoffSleeper(long minWait, long maxWait, double backoffMultiplier) {
        if (minWait <= 0L) {
            throw new IllegalArgumentException("Minimum wait must be at least 1 ms");
        }
        if (maxWait <= minWait) {
            throw new IllegalArgumentException("Maximum wait must be greater than minimum wait");
        }
        if (backoffMultiplier <= 1.0) {
            throw new IllegalArgumentException("Backoff multiplier must be greater than 1.0");
        }
        this._minWait = minWait;
        this._maxWait = maxWait;
        this._backoffMultiplier = backoffMultiplier;
        this.reset();
    }

    public void reset() {
        this._wait = this._minWait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleep() {
        try {
            Object object = this._waiter;
            synchronized (object) {
                this._waiter.wait(this._wait);
            }
        }
        catch (InterruptedException e) {
            this._log.warn((Object)"Sleep interrupted", (Throwable)e);
        }
        if (this._wait < this._maxWait) {
            this._wait = Math.round((double)this._wait * this._backoffMultiplier);
            if (this._wait > this._maxWait) {
                this._wait = this._maxWait;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        Object object = this._waiter;
        synchronized (object) {
            this._waiter.notifyAll();
        }
    }
}

