/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms.connector.typica;

import com.xerox.amazonws.common.AWSError;
import com.xerox.amazonws.common.AWSException;
import com.xerox.amazonws.common.ListResult;
import com.xerox.amazonws.common.Result;
import com.xerox.amazonws.sns.NotificationService;
import com.xerox.amazonws.sns.SNSException;
import com.xerox.amazonws.sqs2.MessageQueue;
import com.xerox.amazonws.sqs2.QueueService;
import com.xerox.amazonws.sqs2.SQSException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.ResourceAllocationException;
import javax.net.ssl.SSLException;
import org.skyscreamer.nevado.jms.connector.AbstractSQSConnector;
import org.skyscreamer.nevado.jms.connector.SQSQueue;
import org.skyscreamer.nevado.jms.connector.typica.TypicaSQSQueue;
import org.skyscreamer.nevado.jms.destination.NevadoQueue;
import org.skyscreamer.nevado.jms.destination.NevadoTopic;

public class TypicaSQSConnector
extends AbstractSQSConnector {
    protected final QueueService _queueService;
    protected final NotificationService _notficationService;

    public TypicaSQSConnector(String awsAccessKey, String awsSecretKey, boolean isSecure, long receiveCheckIntervalMs) {
        super(receiveCheckIntervalMs);
        this._queueService = new QueueService(awsAccessKey, awsSecretKey, isSecure);
        this._notficationService = new NotificationService(awsAccessKey, awsSecretKey, isSecure);
    }

    @Override
    public void test() throws JMSException {
        try {
            this._queueService.listMessageQueues(null);
            this._notficationService.listTopics(null);
        }
        catch (AWSException e) {
            throw this.handleAWSException("Connection test failed", e);
        }
    }

    @Override
    public NevadoTopic createTopic(String topicName) throws JMSException {
        NevadoTopic topic = new NevadoTopic(topicName);
        this.getTopicARN(topic);
        return topic;
    }

    @Override
    public void deleteTopic(NevadoTopic topic) throws JMSException {
        try {
            this._notficationService.deleteTopic(this.getTopicARN(topic));
        }
        catch (SNSException e) {
            throw this.handleAWSException("Unable to delete message topic '" + topic, (AWSException)((Object)e));
        }
    }

    @Override
    public Collection<NevadoTopic> listTopics() throws JMSException {
        ListResult results;
        try {
            results = this._notficationService.listTopics(null);
        }
        catch (SNSException e) {
            throw this.handleAWSException("Unable to list topics", (AWSException)((Object)e));
        }
        HashSet<NevadoTopic> topics = new HashSet<NevadoTopic>(results.getItems().size());
        for (String arn : results.getItems()) {
            topics.add(new NevadoTopic(arn));
        }
        return topics;
    }

    @Override
    public Collection<NevadoQueue> listQueues(String temporaryQueuePrefix) throws JMSException {
        List sqsQueues;
        try {
            sqsQueues = this._queueService.listMessageQueues(temporaryQueuePrefix);
        }
        catch (SQSException e) {
            throw this.handleAWSException("Unable to list queues with prefix '" + temporaryQueuePrefix + "'", (AWSException)((Object)e));
        }
        HashSet<NevadoQueue> queues = new HashSet<NevadoQueue>(sqsQueues.size());
        for (MessageQueue sqsQueue : sqsQueues) {
            URL sqsURL = sqsQueue.getUrl();
            queues.add(new NevadoQueue(sqsURL));
        }
        return queues;
    }

    @Override
    public String subscribe(NevadoTopic topic, NevadoQueue topicEndpoint) throws JMSException {
        String subscriptionArn;
        try {
            SQSQueue queue = this.getSQSQueue(topicEndpoint);
            String sqsArn = queue.getQueueARN();
            String snsArn = this.getTopicARN(topic);
            queue.setPolicy(this.getPolicy(snsArn, sqsArn));
            Result subscribeResult = this._notficationService.subscribe(this.getTopicARN(topic), "sqs", sqsArn);
            subscriptionArn = (String)subscribeResult.getResult();
        }
        catch (AWSException e) {
            throw this.handleAWSException("Unable to subscripe to topic " + topic, e);
        }
        return subscriptionArn;
    }

    @Override
    public void unsubscribe(NevadoTopic topic) throws JMSException {
        if (topic == null) {
            throw new NullPointerException();
        }
        if (topic.getSubscriptionArn() == null) {
            throw new IllegalArgumentException("Topic doesn't have a subscription");
        }
        try {
            this._notficationService.unsubscribe(topic.getSubscriptionArn());
        }
        catch (SNSException e) {
            throw this.handleAWSException("Unable to subscribe topic " + topic + " with sub ARN " + topic.getSubscriptionArn(), (AWSException)((Object)e));
        }
    }

    @Override
    protected void sendSNSMessage(NevadoTopic topic, String serializedMessage) throws JMSException {
        String arn = this.getTopicARN(topic);
        try {
            this._notficationService.publish(arn, serializedMessage, null);
        }
        catch (SNSException e) {
            throw this.handleAWSException("Unable to send message to topic: " + arn, (AWSException)((Object)e));
        }
    }

    @Override
    protected TypicaSQSQueue getSQSQueueImpl(NevadoQueue queue) throws JMSException {
        MessageQueue sqsQueue;
        try {
            if (queue.getQueueUrl() == null) {
                sqsQueue = this._queueService.getOrCreateMessageQueue(queue.getName());
                queue.setQueueUrl(sqsQueue.getUrl().toString());
            } else {
                sqsQueue = this._queueService.getOrCreateMessageQueue(queue.getQueueUrl());
            }
        }
        catch (SQSException e) {
            throw this.handleAWSException("Unable to get message queue '" + queue, (AWSException)((Object)e));
        }
        sqsQueue.setEncoding(false);
        return new TypicaSQSQueue(this, sqsQueue);
    }

    protected String getTopicARN(NevadoTopic topic) throws JMSException {
        if (topic.getArn() == null) {
            Result result;
            try {
                result = this._notficationService.createTopic(topic.getTopicName());
            }
            catch (SNSException e) {
                throw this.handleAWSException("Unable to create/lookup topic: " + topic, (AWSException)((Object)e));
            }
            topic.setArn((String)result.getResult());
        }
        return topic.getArn();
    }

    protected JMSException handleAWSException(String message, AWSException e) {
        String exMessage = message + ": " + e.getMessage();
        this._log.error((Object)exMessage, (Throwable)e);
        Object jmsException = e.getCause() != null && (UnknownHostException.class.equals(e.getCause().getClass()) || SSLException.class.equals(e.getCause().getClass())) ? new ResourceAllocationException(exMessage) : (this.isSecurityException(e) ? new JMSSecurityException(exMessage) : new JMSException(exMessage));
        return jmsException;
    }

    private boolean isSecurityException(AWSException e) {
        boolean securityException = false;
        if (e.getErrors().size() > 0) {
            for (AWSError awsError : e.getErrors()) {
                if (!"InvalidClientTokenId".equals(awsError.getCode())) continue;
                securityException = true;
                break;
            }
        }
        return securityException;
    }
}

