/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms.connector.typica;

import com.xerox.amazonws.common.AWSException;
import com.xerox.amazonws.sqs2.Message;
import com.xerox.amazonws.sqs2.MessageQueue;
import com.xerox.amazonws.sqs2.QueueAttribute;
import com.xerox.amazonws.sqs2.SQSException;
import java.util.Map;
import javax.jms.JMSException;
import org.skyscreamer.nevado.jms.connector.SQSQueue;
import org.skyscreamer.nevado.jms.connector.typica.TypicaSQSConnector;
import org.skyscreamer.nevado.jms.connector.typica.TypicaSQSMessage;

class TypicaSQSQueue
implements SQSQueue {
    private final TypicaSQSConnector _typicaSQSConnector;
    private final MessageQueue _sqsQueue;

    public TypicaSQSQueue(TypicaSQSConnector typicaSQSConnector, MessageQueue sqsQueue) {
        this._typicaSQSConnector = typicaSQSConnector;
        this._sqsQueue = sqsQueue;
    }

    @Override
    public void deleteQueue() throws JMSException {
        try {
            this._sqsQueue.deleteQueue();
        }
        catch (SQSException e) {
            throw this._typicaSQSConnector.handleAWSException("Unable to delete message queue '" + this._sqsQueue.getUrl(), (AWSException)((Object)e));
        }
    }

    @Override
    public String sendMessage(String serializedMessage) throws JMSException {
        try {
            return this._sqsQueue.sendMessage(serializedMessage);
        }
        catch (SQSException e) {
            throw this._typicaSQSConnector.handleAWSException("Unable to send message to queue " + this._sqsQueue.getUrl(), (AWSException)((Object)e));
        }
    }

    @Override
    public void setMessageVisibilityTimeout(String sqsReceiptHandle, int timeout) throws JMSException {
        try {
            this._sqsQueue.setMessageVisibilityTimeout(sqsReceiptHandle, timeout);
        }
        catch (SQSException e) {
            throw this._typicaSQSConnector.handleAWSException("Unable to reset message visibility for message with receipt handle " + sqsReceiptHandle, (AWSException)((Object)e));
        }
    }

    @Override
    public String getQueueARN() throws JMSException {
        Map queueAttrMap = null;
        try {
            queueAttrMap = this._sqsQueue.getQueueAttributes(QueueAttribute.QUEUE_ARN);
        }
        catch (SQSException e) {
            throw this._typicaSQSConnector.handleAWSException("Unable to get queue ARN for queue " + this._sqsQueue.getUrl(), (AWSException)((Object)e));
        }
        return (String)queueAttrMap.get(QueueAttribute.QUEUE_ARN.queryAttribute());
    }

    @Override
    public void setPolicy(String policy) throws JMSException {
        try {
            this._sqsQueue.setQueueAttribute(QueueAttribute.POLICY.queryAttribute(), policy);
        }
        catch (SQSException e) {
            throw this._typicaSQSConnector.handleAWSException("Unable to set policy", (AWSException)((Object)e));
        }
    }

    @Override
    public void deleteMessage(String sqsReceiptHandle) throws JMSException {
        try {
            this._sqsQueue.deleteMessage(sqsReceiptHandle);
        }
        catch (SQSException e) {
            throw this._typicaSQSConnector.handleAWSException("Unable to delete message with receipt handle " + sqsReceiptHandle, (AWSException)((Object)e));
        }
    }

    @Override
    public TypicaSQSMessage receiveMessage() throws JMSException {
        TypicaSQSMessage sqsMessage;
        try {
            Message message = this._sqsQueue.receiveMessage();
            sqsMessage = message != null ? new TypicaSQSMessage(message) : null;
        }
        catch (SQSException e) {
            throw this._typicaSQSConnector.handleAWSException("Unable to retrieve message from queue " + this._sqsQueue.getUrl(), (AWSException)((Object)e));
        }
        return sqsMessage;
    }
}

