/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms.destination;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import org.skyscreamer.nevado.jms.destination.NevadoDestination;
import org.skyscreamer.nevado.jms.destination.NevadoQueue;

public class NevadoTopic
extends NevadoDestination
implements Topic {
    private volatile String _arn;
    private final NevadoQueue _topicEndpoint;
    private final String _subscriptionArn;
    private final boolean _durable;

    public NevadoTopic(String name) {
        super(name.startsWith("arn:") ? name.substring(name.lastIndexOf(":") + 1) : name);
        this._topicEndpoint = null;
        this._subscriptionArn = null;
        this._durable = false;
    }

    protected NevadoTopic(Topic topic) throws JMSException {
        super(topic.getTopicName());
        this._topicEndpoint = null;
        this._subscriptionArn = null;
        this._durable = false;
    }

    public NevadoTopic(NevadoTopic topic, NevadoQueue topicEndpoint, String subscriptionArn, boolean durable) {
        super(topic);
        this._arn = topic.getArn();
        this._topicEndpoint = topicEndpoint;
        this._subscriptionArn = subscriptionArn;
        this._durable = durable;
    }

    public static NevadoTopic getInstance(Topic topic) throws JMSException {
        NevadoTopic nevadoTopic = null;
        if (topic != null) {
            if (topic instanceof NevadoTopic) {
                nevadoTopic = (NevadoTopic)topic;
            } else {
                if (topic instanceof TemporaryTopic) {
                    throw new IllegalStateException("TemporaryDestinations cannot be copied");
                }
                if (topic instanceof Topic) {
                    nevadoTopic = new NevadoTopic(topic);
                }
            }
        }
        return nevadoTopic;
    }

    public String getTopicName() {
        return this.getName();
    }

    public String getArn() {
        return this._arn;
    }

    public void setArn(String arn) {
        this._arn = arn;
    }

    public NevadoQueue getTopicEndpoint() {
        return this._topicEndpoint;
    }

    public String getSubscriptionArn() {
        return this._subscriptionArn;
    }

    public boolean isDurable() {
        return this._durable;
    }
}

