/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms.connector;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.skyscreamer.nevado.jms.NevadoConnection;
import org.skyscreamer.nevado.jms.connector.SQSConnector;
import org.skyscreamer.nevado.jms.connector.SQSMessage;
import org.skyscreamer.nevado.jms.connector.SQSQueue;
import org.skyscreamer.nevado.jms.destination.NevadoDestination;
import org.skyscreamer.nevado.jms.destination.NevadoQueue;
import org.skyscreamer.nevado.jms.destination.NevadoTopic;
import org.skyscreamer.nevado.jms.message.InvalidMessage;
import org.skyscreamer.nevado.jms.message.NevadoMessage;
import org.skyscreamer.nevado.jms.message.NevadoProperty;
import org.skyscreamer.nevado.jms.util.MessageIdUtil;
import org.skyscreamer.nevado.jms.util.SerializeUtil;

public abstract class AbstractSQSConnector
implements SQSConnector {
    protected static final String AWS_ERROR_CODE_AUTHENTICATION = "InvalidClientTokenId";
    protected final Log _log = LogFactory.getLog(this.getClass());
    private final long _receiveCheckIntervalMs;
    private final boolean _isAsync;

    protected AbstractSQSConnector(long receiveCheckIntervalMs) {
        this(receiveCheckIntervalMs, false);
    }

    protected AbstractSQSConnector(long receiveCheckIntervalMs, boolean isAsync) {
        this._receiveCheckIntervalMs = receiveCheckIntervalMs;
        this._isAsync = isAsync;
    }

    public boolean isAsync() {
        return this._isAsync;
    }

    @Override
    public final void sendMessage(NevadoDestination destination, NevadoMessage message) throws JMSException {
        if (destination == null) {
            throw new NullPointerException();
        }
        if (message.isDisableMessageID()) {
            message.setNevadoProperty(NevadoProperty.DisableMessageID, true);
        }
        if (!message.isDisableTimestamp()) {
            message.setJMSTimestamp(System.currentTimeMillis());
        }
        if (destination instanceof NevadoQueue) {
            if (this.isAsync() && !message.isDisableMessageID() && message.getJMSMessageID() == null) {
                message.setJMSMessageID(MessageIdUtil.createMessageId());
            }
            String serializedMessage = this.serializeMessage(message);
            String sqsMessageId = this.sendSQSMessage((NevadoQueue)destination, serializedMessage);
            if (!message.isDisableMessageID() && message.getJMSMessageID() == null) {
                message.setJMSMessageID("ID:" + sqsMessageId);
            }
            this._log.info((Object)("Sent message to SQS " + sqsMessageId));
        } else if (destination instanceof NevadoTopic) {
            if (!message.isDisableMessageID() && message.getJMSMessageID() == null) {
                message.setJMSMessageID("ID:" + MessageIdUtil.createMessageId());
            }
            String serializedMessage = this.serializeMessage(message);
            this.sendSNSMessage((NevadoTopic)destination, serializedMessage);
        } else {
            throw new IllegalStateException("Invalid destination: " + destination.getClass().getName());
        }
    }

    @Override
    public final void sendMessages(NevadoDestination destination, List<NevadoMessage> outgoingMessages) throws JMSException {
        for (NevadoMessage message : outgoingMessages) {
            this.sendMessage(destination, message);
        }
    }

    @Override
    public final NevadoMessage receiveMessage(NevadoConnection connection, NevadoDestination destination, long timeoutMs) throws JMSException, InterruptedException {
        SQSQueue sqsQueue;
        long startTimeMs = new Date().getTime();
        SQSMessage sqsMessage = this.receiveSQSMessage(connection, destination, timeoutMs, startTimeMs, sqsQueue = this.getSQSQueue(destination));
        if (sqsMessage != null) {
            this._log.info((Object)("Received message " + sqsMessage.getMessageId()));
        }
        return sqsMessage != null ? this.convertSqsMessage(destination, sqsMessage, false) : null;
    }

    @Override
    public final void deleteMessage(NevadoMessage message) throws JMSException {
        SQSQueue sqsQueue = this.getSQSQueue(message.getNevadoDestination());
        String sqsReceiptHandle = this.getSQSReceiptHandle(message);
        sqsQueue.deleteMessage(sqsReceiptHandle);
    }

    @Override
    public final void resetMessage(NevadoMessage message) throws JMSException {
        String sqsReceiptHandle = (String)message.getNevadoProperty(NevadoProperty.SQSReceiptHandle);
        if (sqsReceiptHandle == null) {
            throw new JMSException("Message does not contain an SQSReceiptHandle, so cannot be reset.  Did this come from an SQS queue?");
        }
        SQSQueue sqsQueue = this.getSQSQueue(message.getNevadoDestination());
        sqsQueue.setMessageVisibilityTimeout(sqsReceiptHandle, 0);
    }

    @Override
    public final NevadoQueue createQueue(String queueName) throws JMSException {
        NevadoQueue queue = new NevadoQueue(queueName);
        this.getSQSQueue(queue);
        return queue;
    }

    @Override
    public void deleteQueue(NevadoQueue queue) throws JMSException {
        SQSQueue sqsQueue = this.getSQSQueue(queue);
        sqsQueue.deleteQueue();
    }

    protected abstract void sendSNSMessage(NevadoTopic var1, String var2) throws JMSException;

    protected final SQSQueue getSQSQueue(NevadoDestination destination) throws JMSException {
        if (destination == null) {
            throw new JMSException("Destination is null");
        }
        if (destination.isDeleted()) {
            throw new InvalidDestinationException("Destination " + destination + " has been deleted");
        }
        NevadoQueue queue = destination instanceof NevadoQueue ? (NevadoQueue)destination : ((NevadoTopic)destination).getTopicEndpoint();
        return this.getSQSQueueImpl(queue);
    }

    protected abstract SQSQueue getSQSQueueImpl(NevadoQueue var1) throws JMSException;

    protected final SQSMessage receiveSQSMessage(NevadoConnection connection, NevadoDestination destination, long timeoutMs, long startTimeMs, SQSQueue sqsQueue) throws JMSException, InterruptedException {
        SQSMessage sqsMessage;
        while (true) {
            if (connection.isRunning()) {
                sqsMessage = sqsQueue.receiveMessage();
                if (!connection.isRunning()) {
                    try {
                        sqsQueue.setMessageVisibilityTimeout(sqsMessage.getReceiptHandle(), 0);
                    }
                    catch (JMSException e) {
                        String exMessage = "Unable to reset visibility timeout for message: " + e.getMessage();
                        this._log.warn((Object)exMessage, (Throwable)e);
                    }
                    sqsMessage = null;
                }
            } else {
                this._log.debug((Object)"Not accepting messages.  Connection is paused or not started.");
                sqsMessage = null;
            }
            if (sqsMessage != null || timeoutMs > -1L && new Date().getTime() - startTimeMs >= timeoutMs) break;
            Thread.sleep(this._receiveCheckIntervalMs);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Received message: " + (sqsMessage != null ? sqsMessage.getMessageBody() : null)));
        }
        return sqsMessage;
    }

    protected final String sendSQSMessage(NevadoQueue queue, String serializedMessage) throws JMSException {
        SQSQueue sqsQueue = this.getSQSQueue(queue);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Sending message: " + serializedMessage));
        }
        return sqsQueue.sendMessage(serializedMessage);
    }

    protected final NevadoMessage convertSqsMessage(NevadoDestination destination, SQSMessage sqsMessage, boolean readOnly) throws JMSException {
        NevadoMessage message;
        String messageBody;
        if (destination instanceof NevadoQueue) {
            messageBody = sqsMessage.getMessageBody();
        } else {
            try {
                messageBody = new JSONObject(sqsMessage.getMessageBody()).getString("Message");
            }
            catch (JSONException e) {
                throw new JMSException("Unable to parse JSON from message body: " + sqsMessage.getMessageBody());
            }
        }
        try {
            message = this.deserializeMessage(messageBody);
        }
        catch (JMSException e) {
            message = new InvalidMessage((Exception)((Object)e));
        }
        if (message.nevadoPropertyExists(NevadoProperty.DisableMessageID) && ((Boolean)message.getNevadoProperty(NevadoProperty.DisableMessageID)).booleanValue()) {
            message.setJMSMessageID(null);
        } else if (message.getJMSMessageID() == null) {
            message.setJMSMessageID("ID:" + sqsMessage.getMessageId());
        }
        message.setNevadoProperty(NevadoProperty.SQSReceiptHandle, sqsMessage.getReceiptHandle());
        message.setJMSDestination(destination);
        message.setReadOnly(readOnly);
        return message;
    }

    protected final String serializeMessage(NevadoMessage message) throws JMSException {
        String serializedMessage;
        try {
            serializedMessage = SerializeUtil.serializeToString(message);
        }
        catch (IOException e) {
            String exMessage = "Unable to serialize message of type " + message.getClass().getName() + ": " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
        return serializedMessage;
    }

    protected final NevadoMessage deserializeMessage(String serializedMessage) throws JMSException {
        Serializable deserializedObject;
        try {
            deserializedObject = SerializeUtil.deserializeFromString(serializedMessage);
        }
        catch (IOException e) {
            String exMessage = "Unable to deserialized message: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
        if (deserializedObject == null) {
            throw new JMSException("Deserialized object is null");
        }
        if (!(deserializedObject instanceof NevadoMessage)) {
            throw new JMSException("Expected object of type NevadoMessage, got: " + deserializedObject.getClass().getName());
        }
        return (NevadoMessage)deserializedObject;
    }

    protected final String getPolicy(String snsArn, String sqsArn) {
        return "{ \n    \"Version\":\"2008-10-17\", \n    \"Id\":\"" + sqsArn + "\", \n" + "    \"Statement\": [ \n" + "        { \n" + "            \"Sid\":\"" + sqsArn + "/statementId\", \n" + "            \"Effect\":\"Allow\", \n" + "            \"Principal\":{\"AWS\":\"*\"}, \n" + "            \"Action\":\"SQS:SendMessage\", \n" + "            \"Resource\": \"" + sqsArn + "\", \n" + "            \"Condition\":{ \n" + "                \"StringEquals\":{\"aws:SourceArn\":\"" + snsArn + "\"} \n" + "            } \n" + "        } \n" + "    ] \n" + "}";
    }

    private String getSQSReceiptHandle(NevadoMessage message) throws JMSException {
        String sqsReceiptHandle = (String)message.getNevadoProperty(NevadoProperty.SQSReceiptHandle);
        if (sqsReceiptHandle == null) {
            throw new JMSException("Invalid null SQS receipt handle");
        }
        return sqsReceiptHandle;
    }
}

