/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.StreamMessage;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.skyscreamer.nevado.jms.message.ByteArray;
import org.skyscreamer.nevado.jms.message.NevadoMessage;
import org.skyscreamer.nevado.jms.util.MarshallingSupport;

public class NevadoStreamMessage
extends NevadoMessage
implements StreamMessage {
    private transient Log _log = LogFactory.getLog(NevadoStreamMessage.class);
    private ByteArray _body;
    protected transient DataOutputStream dataOut;
    protected transient ByteArrayOutputStream bytesOut;
    protected transient DataInputStream dataIn;
    protected int remainingBytes = -1;

    public NevadoStreamMessage() {
    }

    protected NevadoStreamMessage(StreamMessage message) throws JMSException {
        super((Message)message);
        message.reset();
        try {
            while (true) {
                Object o = message.readObject();
                this.writeObject(o);
            }
        }
        catch (MessageEOFException e) {
            this.storeContent();
            return;
        }
    }

    @Override
    public void internalClearBody() throws JMSException {
        this._body = null;
        this.dataOut = null;
        this.dataIn = null;
        this.bytesOut = null;
        this.remainingBytes = -1;
    }

    @Override
    public void onSend() {
        super.onSend();
        this.storeContent();
    }

    private void storeContent() {
        if (this.dataOut != null) {
            try {
                this.dataOut.close();
                this._body = new ByteArray(this.bytesOut.toByteArray());
                this.bytesOut = null;
                this.dataOut = null;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public boolean readBoolean() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(10);
            int type = this.dataIn.read();
            if (type == -1) {
                throw new MessageEOFException("reached end of data");
            }
            if (type == 1) {
                return this.dataIn.readBoolean();
            }
            if (type == 9) {
                return Boolean.valueOf(this.dataIn.readUTF());
            }
            if (type == 0) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert NULL value to boolean.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a boolean type");
        }
        catch (EOFException e) {
            String exMessage = "Reached premature EOF: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
        catch (IOException e) {
            String exMessage = "Could not read boolean: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
    }

    public byte readByte() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(10);
            int type = this.dataIn.read();
            if (type == -1) {
                throw new MessageEOFException("reached end of data");
            }
            if (type == 2) {
                return this.dataIn.readByte();
            }
            if (type == 9) {
                return Byte.valueOf(this.dataIn.readUTF());
            }
            if (type == 0) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert NULL value to byte.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a byte type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException ioe) {
                MessageFormatException jmsEx = new MessageFormatException(ioe.getMessage());
                jmsEx.setLinkedException((Exception)ioe);
                throw jmsEx;
            }
            throw mfe;
        }
        catch (EOFException e) {
            String exMessage = "Reached premature EOF: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
        catch (IOException e) {
            String exMessage = "Could not read boolean: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
    }

    public short readShort() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(17);
            int type = this.dataIn.read();
            if (type == -1) {
                throw new MessageEOFException("reached end of data");
            }
            if (type == 4) {
                return this.dataIn.readShort();
            }
            if (type == 2) {
                return this.dataIn.readByte();
            }
            if (type == 9) {
                return Short.valueOf(this.dataIn.readUTF());
            }
            if (type == 0) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert NULL value to short.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a short type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException ioe) {
                MessageFormatException jmsEx = new MessageFormatException(ioe.getMessage());
                jmsEx.setLinkedException((Exception)ioe);
                throw jmsEx;
            }
            throw mfe;
        }
        catch (EOFException e) {
            String exMessage = "Reached premature EOF: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
        catch (IOException e) {
            String exMessage = "Could not read boolean: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
    }

    public char readChar() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(17);
            int type = this.dataIn.read();
            if (type == -1) {
                throw new MessageEOFException("reached end of data");
            }
            if (type == 3) {
                return this.dataIn.readChar();
            }
            if (type == 0) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert NULL value to char.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a char type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException ioe) {
                MessageFormatException jmsEx = new MessageFormatException(ioe.getMessage());
                jmsEx.setLinkedException((Exception)ioe);
                throw jmsEx;
            }
            throw mfe;
        }
        catch (EOFException e) {
            String exMessage = "Reached premature EOF: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
        catch (IOException e) {
            String exMessage = "Could not read boolean: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
    }

    public int readInt() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(33);
            int type = this.dataIn.read();
            if (type == -1) {
                throw new MessageEOFException("reached end of data");
            }
            if (type == 5) {
                return this.dataIn.readInt();
            }
            if (type == 4) {
                return this.dataIn.readShort();
            }
            if (type == 2) {
                return this.dataIn.readByte();
            }
            if (type == 9) {
                return Integer.valueOf(this.dataIn.readUTF());
            }
            if (type == 0) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert NULL value to int.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not an int type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException ioe) {
                MessageFormatException jmsEx = new MessageFormatException(ioe.getMessage());
                jmsEx.setLinkedException((Exception)ioe);
                throw jmsEx;
            }
            throw mfe;
        }
        catch (EOFException e) {
            String exMessage = "Reached premature EOF: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
        catch (IOException e) {
            String exMessage = "Could not read boolean: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
    }

    public long readLong() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(65);
            int type = this.dataIn.read();
            if (type == -1) {
                throw new MessageEOFException("reached end of data");
            }
            if (type == 6) {
                return this.dataIn.readLong();
            }
            if (type == 5) {
                return this.dataIn.readInt();
            }
            if (type == 4) {
                return this.dataIn.readShort();
            }
            if (type == 2) {
                return this.dataIn.readByte();
            }
            if (type == 9) {
                return Long.valueOf(this.dataIn.readUTF());
            }
            if (type == 0) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert NULL value to long.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a long type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException ioe) {
                MessageFormatException jmsEx = new MessageFormatException(ioe.getMessage());
                jmsEx.setLinkedException((Exception)ioe);
                throw jmsEx;
            }
            throw mfe;
        }
        catch (EOFException e) {
            String exMessage = "Reached premature EOF: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
        catch (IOException e) {
            String exMessage = "Could not read boolean: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
    }

    public float readFloat() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(33);
            int type = this.dataIn.read();
            if (type == -1) {
                throw new MessageEOFException("reached end of data");
            }
            if (type == 8) {
                return this.dataIn.readFloat();
            }
            if (type == 9) {
                return Float.valueOf(this.dataIn.readUTF()).floatValue();
            }
            if (type == 0) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert NULL value to float.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a float type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException ioe) {
                MessageFormatException jmsEx = new MessageFormatException(ioe.getMessage());
                jmsEx.setLinkedException((Exception)ioe);
                throw jmsEx;
            }
            throw mfe;
        }
        catch (EOFException e) {
            String exMessage = "Reached premature EOF: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
        catch (IOException e) {
            String exMessage = "Could not read boolean: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
    }

    public double readDouble() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(65);
            int type = this.dataIn.read();
            if (type == -1) {
                throw new MessageEOFException("reached end of data");
            }
            if (type == 7) {
                return this.dataIn.readDouble();
            }
            if (type == 8) {
                return this.dataIn.readFloat();
            }
            if (type == 9) {
                return Double.valueOf(this.dataIn.readUTF());
            }
            if (type == 0) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert NULL value to double.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a double type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException ioe) {
                MessageFormatException jmsEx = new MessageFormatException(ioe.getMessage());
                jmsEx.setLinkedException((Exception)ioe);
                throw jmsEx;
            }
            throw mfe;
        }
        catch (EOFException e) {
            String exMessage = "Reached premature EOF: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
        catch (IOException e) {
            String exMessage = "Could not read boolean: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
    }

    public String readString() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(65);
            int type = this.dataIn.read();
            if (type == -1) {
                throw new MessageEOFException("reached end of data");
            }
            if (type == 0) {
                return null;
            }
            if (type == 13) {
                return MarshallingSupport.readUTF8(this.dataIn);
            }
            if (type == 9) {
                return this.dataIn.readUTF();
            }
            if (type == 6) {
                return new Long(this.dataIn.readLong()).toString();
            }
            if (type == 5) {
                return new Integer(this.dataIn.readInt()).toString();
            }
            if (type == 4) {
                return new Short(this.dataIn.readShort()).toString();
            }
            if (type == 2) {
                return new Byte(this.dataIn.readByte()).toString();
            }
            if (type == 8) {
                return new Float(this.dataIn.readFloat()).toString();
            }
            if (type == 7) {
                return new Double(this.dataIn.readDouble()).toString();
            }
            if (type == 1) {
                return (this.dataIn.readBoolean() ? Boolean.TRUE : Boolean.FALSE).toString();
            }
            if (type == 3) {
                return new Character(this.dataIn.readChar()).toString();
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a String type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException ioe) {
                MessageFormatException jmsEx = new MessageFormatException(ioe.getMessage());
                jmsEx.setLinkedException((Exception)ioe);
                throw jmsEx;
            }
            throw mfe;
        }
        catch (EOFException e) {
            String exMessage = "Reached premature EOF: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
        catch (IOException e) {
            String exMessage = "Could not read boolean: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        this.initializeReading();
        try {
            if (value == null) {
                throw new NullPointerException();
            }
            if (this.remainingBytes == -1) {
                this.dataIn.mark(value.length + 1);
                int type = this.dataIn.read();
                if (type == -1) {
                    throw new MessageEOFException("reached end of data");
                }
                if (type != 10) {
                    throw new MessageFormatException("Not a byte array");
                }
                this.remainingBytes = this.dataIn.readInt();
            } else if (this.remainingBytes == 0) {
                this.remainingBytes = -1;
                return -1;
            }
            if (value.length <= this.remainingBytes) {
                this.remainingBytes -= value.length;
                this.dataIn.readFully(value);
                return value.length;
            }
            int rc = this.dataIn.read(value, 0, this.remainingBytes);
            this.remainingBytes = 0;
            return rc;
        }
        catch (EOFException e) {
            MessageEOFException jmsEx = new MessageEOFException(e.getMessage());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        catch (IOException e) {
            MessageFormatException jmsEx = new MessageFormatException(e.getMessage());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public Object readObject() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(65);
            int type = this.dataIn.read();
            if (type == -1) {
                throw new MessageEOFException("reached end of data");
            }
            if (type == 0) {
                return null;
            }
            if (type == 13) {
                return MarshallingSupport.readUTF8(this.dataIn);
            }
            if (type == 9) {
                return this.dataIn.readUTF();
            }
            if (type == 6) {
                return new Long(this.dataIn.readLong());
            }
            if (type == 5) {
                return new Integer(this.dataIn.readInt());
            }
            if (type == 4) {
                return new Short(this.dataIn.readShort());
            }
            if (type == 2) {
                return new Byte(this.dataIn.readByte());
            }
            if (type == 8) {
                return new Float(this.dataIn.readFloat());
            }
            if (type == 7) {
                return new Double(this.dataIn.readDouble());
            }
            if (type == 1) {
                return this.dataIn.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (type == 3) {
                return new Character(this.dataIn.readChar());
            }
            if (type == 10) {
                int len = this.dataIn.readInt();
                byte[] value = new byte[len];
                this.dataIn.readFully(value);
                return value;
            }
            this.dataIn.reset();
            throw new MessageFormatException("unknown type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException ioe) {
                MessageFormatException jmsEx = new MessageFormatException(ioe.getMessage());
                jmsEx.setLinkedException((Exception)ioe);
                throw jmsEx;
            }
            throw mfe;
        }
        catch (EOFException e) {
            MessageEOFException jmsEx = new MessageEOFException(e.getMessage());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        catch (IOException e) {
            MessageFormatException jmsEx = new MessageFormatException(e.getMessage());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.initializeWriting();
        try {
            MarshallingSupport.marshalBoolean(this.dataOut, value);
        }
        catch (IOException e) {
            String exMessage = "Could not write boolean: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
    }

    public void writeByte(byte value) throws JMSException {
        this.initializeWriting();
        try {
            MarshallingSupport.marshalByte(this.dataOut, value);
        }
        catch (IOException e) {
            String exMessage = "Could not write byte: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
    }

    public void writeShort(short value) throws JMSException {
        this.initializeWriting();
        try {
            MarshallingSupport.marshalShort(this.dataOut, value);
        }
        catch (IOException e) {
            String exMessage = "Could not write short: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
    }

    public void writeChar(char value) throws JMSException {
        this.initializeWriting();
        try {
            MarshallingSupport.marshalChar(this.dataOut, value);
        }
        catch (IOException e) {
            String exMessage = "Could not write short: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
    }

    public void writeInt(int value) throws JMSException {
        this.initializeWriting();
        try {
            MarshallingSupport.marshalInt(this.dataOut, value);
        }
        catch (IOException e) {
            String exMessage = "Could not write int: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
    }

    public void writeLong(long value) throws JMSException {
        this.initializeWriting();
        try {
            MarshallingSupport.marshalLong(this.dataOut, value);
        }
        catch (IOException e) {
            String exMessage = "Could not write long: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
    }

    public void writeFloat(float value) throws JMSException {
        this.initializeWriting();
        try {
            MarshallingSupport.marshalFloat(this.dataOut, value);
        }
        catch (IOException e) {
            String exMessage = "Could not write float: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
    }

    public void writeDouble(double value) throws JMSException {
        this.initializeWriting();
        try {
            MarshallingSupport.marshalDouble(this.dataOut, value);
        }
        catch (IOException e) {
            String exMessage = "Could not write double: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
    }

    public void writeString(String value) throws JMSException {
        this.initializeWriting();
        try {
            if (value == null) {
                MarshallingSupport.marshalNull(this.dataOut);
            } else {
                MarshallingSupport.marshalString(this.dataOut, value);
            }
        }
        catch (IOException e) {
            String exMessage = "Could not write string: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.writeBytes(value, 0, value.length);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.initializeWriting();
        try {
            MarshallingSupport.marshalByteArray(this.dataOut, value, offset, length);
        }
        catch (IOException e) {
            String exMessage = "Could not write byte[]: " + e.getMessage();
            this._log.error((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
    }

    public void writeObject(Object value) throws JMSException {
        this.initializeWriting();
        if (value == null) {
            try {
                MarshallingSupport.marshalNull(this.dataOut);
            }
            catch (IOException e) {
                String exMessage = "Could not write object: " + e.getMessage();
                this._log.error((Object)exMessage, (Throwable)e);
                throw new JMSException(exMessage);
            }
        } else if (value instanceof String) {
            this.writeString(value.toString());
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        }
    }

    public void reset() throws JMSException {
        this.storeContent();
        this.bytesOut = null;
        this.dataIn = null;
        this.dataOut = null;
        this.remainingBytes = -1;
    }

    private void initializeWriting() throws MessageNotWriteableException {
        this.checkReadOnlyBody();
        if (this.dataOut == null) {
            ByteArrayOutputStream os = this.bytesOut = new ByteArrayOutputStream();
            this.dataOut = new DataOutputStream(os);
        }
    }

    private void initializeReading() throws MessageNotReadableException {
        this.checkWriteOnlyBody();
        if (this.dataIn == null) {
            ByteArrayInputStream is = new ByteArrayInputStream(this._body != null ? this._body.toByteArray() : new byte[]{});
            this.dataIn = new DataInputStream(is);
        }
    }

    public String toString() {
        return super.toString() + " NevadoStreamMessage{ " + "bytesOut = " + this.bytesOut + ", dataOut = " + this.dataOut + ", dataIn = " + this.dataIn + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NevadoStreamMessage that = (NevadoStreamMessage)o;
        if (this._messageID != null ? !this._messageID.equals(that._messageID) : that._messageID != null) {
            return false;
        }
        return !(this._body != null ? !this._body.equals(that._body) : that._body != null);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this._messageID).append((Object)this._body).toHashCode();
    }
}

