/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms.message;

import java.util.ArrayList;
import java.util.List;

public enum JMSXProperty {
    JMSXUserID(String.class, false),
    JMSXAppID(String.class, false),
    JMSXDeliveryCount(Integer.class, true),
    JMSXGroupID(String.class, true),
    JMSXGroupSeq(Integer.class, true),
    JMSXProducerTXID(String.class, false),
    JMSXConsumerTXID(String.class, false),
    JMSXRcvTimestamp(Long.class, false),
    JMSXState(Integer.class, false);

    private static List<JMSXProperty> SUPPORTED_PROPERTIES;
    private final Class _type;
    private final boolean _supported;

    private JMSXProperty(Class type, boolean supported) {
        this._type = type;
        this._supported = supported;
    }

    public static synchronized List<JMSXProperty> getSupportedProperties() {
        if (SUPPORTED_PROPERTIES == null) {
            JMSXProperty.initializeProperties();
        }
        return SUPPORTED_PROPERTIES;
    }

    private static void initializeProperties() {
        SUPPORTED_PROPERTIES = new ArrayList<JMSXProperty>();
        for (JMSXProperty property : JMSXProperty.values()) {
            if (!property.isSupported()) continue;
            SUPPORTED_PROPERTIES.add(property);
        }
    }

    public Class getType() {
        return this._type;
    }

    public boolean isSupported() {
        return this._supported;
    }

    static {
        SUPPORTED_PROPERTIES = null;
    }
}

