/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms;

import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.skyscreamer.nevado.jms.NevadoConnection;
import org.skyscreamer.nevado.jms.NevadoMessageConsumer;
import org.skyscreamer.nevado.jms.NevadoMessageProducer;
import org.skyscreamer.nevado.jms.NevadoSession;
import org.skyscreamer.nevado.jms.destination.NevadoQueue;
import org.skyscreamer.nevado.jms.destination.NevadoTemporaryQueue;

public class NevadoTopicSession
extends NevadoSession
implements TopicSession {
    protected NevadoTopicSession(NevadoConnection connection, boolean transacted, int acknowledgeMode) {
        super(connection, transacted, acknowledgeMode);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.checkClosed();
        return super.createConsumer((Destination)topic);
    }

    public TopicSubscriber createSubscriber(Topic topic, String selector, boolean noLocal) throws JMSException {
        this.checkClosed();
        return super.createConsumer((Destination)topic, selector, noLocal);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.checkClosed();
        return super.createProducer((Destination)topic);
    }

    @Override
    public NevadoMessageProducer createProducer(Destination destination) throws JMSException {
        this.checkIsTopic(destination);
        return super.createProducer(destination);
    }

    @Override
    public NevadoMessageConsumer createConsumer(Destination destination) throws JMSException {
        this.checkIsTopic(destination);
        return super.createConsumer(destination);
    }

    @Override
    public NevadoMessageConsumer createConsumer(Destination destination, String selector) throws JMSException {
        this.checkIsTopic(destination);
        return super.createConsumer(destination, selector);
    }

    @Override
    public NevadoMessageConsumer createConsumer(Destination destination, String selector, boolean noLocal) throws JMSException {
        this.checkIsTopic(destination);
        return super.createConsumer(destination, selector, noLocal);
    }

    private void checkIsTopic(Destination destination) throws IllegalStateException {
        if (!(destination instanceof Topic)) {
            throw new IllegalStateException("TopicSession does not handle destinations of type " + destination.getClass().getName());
        }
    }

    @Override
    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        throw new IllegalStateException("TopicSession will not perform queue operations");
    }

    @Override
    public QueueBrowser createBrowser(Queue queue, String s) throws JMSException {
        throw new IllegalStateException("TopicSession will not perform queue operations");
    }

    @Override
    public NevadoTemporaryQueue createTemporaryQueue() throws JMSException {
        throw new IllegalStateException("TopicSession will not perform queue operations");
    }

    @Override
    public NevadoQueue createQueue(String s) throws JMSException {
        throw new IllegalStateException("TopicSession will not perform queue operations");
    }
}

