/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms.message;

import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.skyscreamer.nevado.jms.NevadoSession;
import org.skyscreamer.nevado.jms.destination.NevadoDestination;
import org.skyscreamer.nevado.jms.message.AbstractMessage;
import org.skyscreamer.nevado.jms.message.JMSXProperty;
import org.skyscreamer.nevado.jms.message.NevadoBytesMessage;
import org.skyscreamer.nevado.jms.message.NevadoMapMessage;
import org.skyscreamer.nevado.jms.message.NevadoObjectMessage;
import org.skyscreamer.nevado.jms.message.NevadoProperty;
import org.skyscreamer.nevado.jms.message.NevadoStreamMessage;
import org.skyscreamer.nevado.jms.message.NevadoTextMessage;

public abstract class NevadoMessage
extends AbstractMessage<NevadoMessage>
implements Message {
    private transient NevadoSession _nevadoSession;
    private transient NevadoDestination _nevadoDestination;
    private transient boolean _acknowledged = false;
    private transient boolean _disableMessageID = false;
    private transient boolean _disableTimestamp = false;
    private transient boolean _readOnly = false;
    private transient int _localDeliveryCount = 0;

    public NevadoMessage() {
    }

    protected NevadoMessage(Message message) throws JMSException {
        this.setJMSMessageID(message.getJMSMessageID());
        this.setJMSCorrelationID(message.getJMSCorrelationID());
        this.setJMSReplyTo(NevadoDestination.getInstance(message.getJMSReplyTo()));
        this.setJMSDestination(NevadoDestination.getInstance(message.getJMSDestination()));
        this.setJMSDeliveryMode(message.getJMSDeliveryMode());
        this.setJMSRedelivered(message.getJMSRedelivered());
        this.setJMSType(message.getJMSType());
        this.setJMSExpiration(message.getJMSExpiration());
        this.setJMSPriority(message.getJMSPriority());
        this.setJMSTimestamp(message.getJMSTimestamp());
        Enumeration propertyNames = message.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = propertyNames.nextElement().toString();
            Object obj = message.getObjectProperty(name);
            this.setObjectProperty(name, obj);
        }
    }

    public NevadoSession getNevadoSession() {
        return this._nevadoSession;
    }

    public void setNevadoSession(NevadoSession nevadoSession) {
        this._nevadoSession = nevadoSession;
    }

    public NevadoDestination getNevadoDestination() {
        return this._nevadoDestination;
    }

    public void setNevadoDestination(NevadoDestination nevadoDestination) {
        this._nevadoDestination = nevadoDestination;
    }

    public boolean nevadoPropertyExists(NevadoProperty property) throws JMSException {
        return super.propertyExists((Object)((Object)property) + "");
    }

    public Object getNevadoProperty(NevadoProperty nevadoProperty) throws JMSException {
        return super.getObjectProperty((Object)((Object)nevadoProperty) + "");
    }

    public void setNevadoProperty(NevadoProperty nevadoProperty, Object value) throws JMSException {
        if (!nevadoProperty.getPropertyType().isAssignableFrom(value.getClass())) {
            throw new MessageFormatException("Invalid property type for " + (Object)((Object)nevadoProperty) + " (" + ((Object)((Object)nevadoProperty)).getClass().getName() + ": " + value.getClass().getName());
        }
        super.internalSetObjectProperty((Object)((Object)nevadoProperty) + "", value);
    }

    @Override
    public void acknowledge() throws JMSException {
        this.checkReadOnly();
        if (!this._acknowledged) {
            this._nevadoSession.acknowledgeMessage(this);
            this._acknowledged = true;
        }
    }

    private void checkReadOnly() throws IllegalStateException {
        if (this._readOnly) {
            throw new IllegalStateException("This message is only for browsing and cannot be acknowledged");
        }
    }

    public void expire() throws JMSException {
        this.checkReadOnly();
        this._nevadoSession.expireMessage(this);
    }

    public static NevadoMessage getInstance(Message message) throws JMSException {
        NevadoMessage nevadoMessage = null;
        if (message != null) {
            if (message instanceof NevadoMessage) {
                nevadoMessage = (NevadoMessage)message;
            } else if (message instanceof StreamMessage) {
                nevadoMessage = new NevadoStreamMessage((StreamMessage)message);
            } else if (message instanceof MapMessage) {
                nevadoMessage = new NevadoMapMessage((MapMessage)message);
            } else if (message instanceof TextMessage) {
                nevadoMessage = new NevadoTextMessage((TextMessage)message);
            } else if (message instanceof ObjectMessage) {
                nevadoMessage = new NevadoObjectMessage((ObjectMessage)message);
            } else if (message instanceof BytesMessage) {
                nevadoMessage = new NevadoBytesMessage((BytesMessage)message);
            } else {
                throw new UnsupportedOperationException("Unable to parse message of type: " + message.getClass().getName());
            }
        }
        return nevadoMessage;
    }

    public void setJMSXProperty(JMSXProperty property, Object value) throws JMSException {
        if (!property.getType().isAssignableFrom(value.getClass())) {
            throw new MessageFormatException("Invalid property type for " + (Object)((Object)property) + " (" + ((Object)((Object)property)).getClass().getName() + ": " + value.getClass().getName());
        }
        super.internalSetObjectProperty((Object)((Object)property) + "", value);
    }

    public Object getJMSXProperty(JMSXProperty property) throws JMSException {
        return super.getObjectProperty((Object)((Object)property) + "");
    }

    public boolean isAcknowledged() {
        return this._acknowledged;
    }

    public void setAcknowledged(boolean acknowledged) {
        this._acknowledged = acknowledged;
    }

    public boolean isDisableMessageID() {
        return this._disableMessageID;
    }

    public void setDisableMessageID(boolean _disableMessageID) {
        this._disableMessageID = _disableMessageID;
    }

    public boolean isDisableTimestamp() {
        return this._disableTimestamp;
    }

    public void setDisableTimestamp(boolean _disableTimestamp) {
        this._disableTimestamp = _disableTimestamp;
    }

    public void setReadOnly(boolean readOnly) {
        this._readOnly = readOnly;
    }

    public int getLocalDeliveryCount() {
        return this._localDeliveryCount;
    }

    public void incrementLocalDeliveryCount() {
        ++this._localDeliveryCount;
    }
}

