/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.mapper;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.skyscreamer.yoga.annotations.URITemplate;
import org.skyscreamer.yoga.mapper.ClassFinderStrategy;
import org.skyscreamer.yoga.mapper.HierarchicalModel;
import org.skyscreamer.yoga.populator.DefaultFieldPopulatorRegistry;
import org.skyscreamer.yoga.populator.ExtraField;
import org.skyscreamer.yoga.populator.FieldPopulator;
import org.skyscreamer.yoga.populator.FieldPopulatorRegistry;
import org.skyscreamer.yoga.populator.ValueReader;
import org.skyscreamer.yoga.selector.Selector;
import org.skyscreamer.yoga.uri.AnnotationURITemplateGenerator;
import org.skyscreamer.yoga.uri.URICreator;
import org.skyscreamer.yoga.uri.URITemplateGenerator;

public class ResultTraverser {
    private FieldPopulatorRegistry _fieldPopulatorRegistry = new DefaultFieldPopulatorRegistry(new ArrayList());
    private URICreator _uriCreator = new URICreator();
    private URITemplateGenerator _uriTemplateGenerator = new AnnotationURITemplateGenerator();
    private ClassFinderStrategy _classFinderStrategy = new DefaultClassFinderStrategy();
    private boolean _showDefinition = false;
    private boolean _showHref = true;

    public void traverse(Object instance, Selector fieldSelector, HierarchicalModel model, String hrefSuffix) {
        Class<?> instanceType = this.findClass(instance);
        this.addExtraInfo(instance, fieldSelector, model, instanceType, hrefSuffix);
        this.addProperties(instance, fieldSelector, model, instanceType, hrefSuffix);
    }

    protected void addExtraInfo(Object instance, Selector fieldSelector, HierarchicalModel model, Class<?> instanceType, String hrefSuffix) {
        FieldPopulator<?> populator = this._fieldPopulatorRegistry.getFieldPopulator(instanceType);
        if (this._showHref) {
            this.addHref(instance, model, instanceType, hrefSuffix, populator);
        }
        if (this._showDefinition) {
            this.addDefinition(model, instanceType, populator);
        }
        this.addAnnotatedExtraFields(fieldSelector, model, hrefSuffix, populator, instance, instanceType);
    }

    private void addAnnotatedExtraFields(Selector fieldSelector, HierarchicalModel model, String hrefSuffix, FieldPopulator populator, Object instance, Class<?> instanceType) {
        for (Method method : this.getPopulatorExtraFieldMethods(populator, instanceType)) {
            Object fieldValue;
            ExtraField extraField = method.getAnnotation(ExtraField.class);
            if (!fieldSelector.containsField(extraField.value())) continue;
            try {
                fieldValue = method.getParameterTypes().length == 0 ? method.invoke((Object)populator, new Object[0]) : method.invoke((Object)populator, instance);
            }
            catch (Exception e) {
                continue;
            }
            Selector childSelector = fieldSelector.getField(extraField.value());
            if (this.isNotBean(fieldValue.getClass())) {
                model.addSimple(extraField.value(), fieldValue);
                continue;
            }
            if (Iterable.class.isAssignableFrom(fieldValue.getClass())) {
                this.traverseIterable(childSelector, model, extraField.value(), (Iterable)fieldValue, hrefSuffix);
                continue;
            }
            this.traverseChild(childSelector, model, extraField.value(), fieldValue, hrefSuffix);
        }
    }

    private void addDefinition(HierarchicalModel model, Class<?> instanceType, FieldPopulator populator) {
        List<Object> definition = new ArrayList();
        if (populator != null && populator.getSupportedFields() != null) {
            definition = populator.getSupportedFields();
        } else {
            for (PropertyDescriptor property : this.getReadableProperties(instanceType)) {
                if (property.getName().equals("class")) continue;
                definition.add(property.getName());
            }
            for (Method method : this.getPopulatorExtraFieldMethods(populator, instanceType)) {
                ExtraField extraField = method.getAnnotation(ExtraField.class);
                definition.add(extraField.value());
            }
        }
        model.addSimple("definition", definition);
    }

    private List<Method> getPopulatorExtraFieldMethods(FieldPopulator populator, Class<?> instanceType) {
        ArrayList<Method> result = new ArrayList<Method>();
        if (populator != null) {
            for (Method method : populator.getClass().getDeclaredMethods()) {
                Class<?>[] parameterTypes;
                if (!method.isAnnotationPresent(ExtraField.class) || (parameterTypes = method.getParameterTypes()).length != 0 && (parameterTypes.length != 1 || !parameterTypes[0].equals(instanceType))) continue;
                result.add(method);
            }
        }
        return result;
    }

    private void addHref(Object instance, HierarchicalModel model, Class<?> instanceType, String hrefSuffix, FieldPopulator populator) {
        String href = null;
        if (instanceType.isAnnotationPresent(URITemplate.class)) {
            href = instanceType.getAnnotation(URITemplate.class).value();
        } else if (populator != null && populator.getUriTemplate() != null) {
            href = populator.getUriTemplate();
        }
        if (href != null) {
            if (hrefSuffix != null) {
                href = href + "." + hrefSuffix;
            }
            model.addSimple("href", this.getHref(href, instance));
        }
    }

    protected void addProperties(Object instance, Selector fieldSelector, HierarchicalModel model, Class<?> instanceType, String hrefSuffix) {
        FieldPopulator<?> fieldPopulator = this._fieldPopulatorRegistry.getFieldPopulator(instanceType);
        for (PropertyDescriptor property : this.getReadableProperties(instanceType)) {
            try {
                if (!fieldSelector.containsField(property, fieldPopulator)) continue;
                Object value = PropertyUtils.getNestedProperty((Object)instance, (String)property.getName());
                Class<?> propertyType = property.getPropertyType();
                if (this.isNotBean(propertyType)) {
                    model.addSimple(property, value);
                    continue;
                }
                if (Iterable.class.isAssignableFrom(propertyType)) {
                    this.traverseIterable(fieldSelector, model, property, (Iterable)value, hrefSuffix);
                    continue;
                }
                this.traverseChild(fieldSelector, model, property, value, hrefSuffix);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private List<PropertyDescriptor> getReadableProperties(Class<?> instanceType) {
        ArrayList<PropertyDescriptor> result = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor descriptor : PropertyUtils.getPropertyDescriptors(instanceType)) {
            if (descriptor.getReadMethod() == null || descriptor.getName().equals("class")) continue;
            result.add(descriptor);
        }
        return result;
    }

    protected Object getHref(String uriTemplate, final Object instance) {
        return this._uriCreator.getHref(uriTemplate, new ValueReader(){

            @Override
            public Object getValue(String property) {
                try {
                    return PropertyUtils.getNestedProperty((Object)instance, (String)property);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not invoke getter for property " + property + " on class " + instance.getClass().getName(), e);
                }
            }
        });
    }

    private void traverseIterable(Selector fieldSelector, HierarchicalModel model, PropertyDescriptor property, Iterable<?> list, String hrefSuffix) {
        HierarchicalModel listModel = model.createList(property, list);
        for (Object o : list) {
            Class<?> type = this.findClass(o);
            if (this.isNotBean(type)) {
                listModel.addSimple(property, list);
                continue;
            }
            this.traverseChild(fieldSelector, listModel, property, o, hrefSuffix);
        }
    }

    private void traverseIterable(Selector fieldSelector, HierarchicalModel model, String property, Iterable<?> list, String hrefSuffix) {
        HierarchicalModel listModel = model.createList(property, list);
        for (Object o : list) {
            Class<?> type = this.findClass(o);
            if (this.isNotBean(type)) {
                listModel.addSimple(property, list);
                continue;
            }
            this.traverseChild(fieldSelector, listModel, property, o, hrefSuffix);
        }
    }

    private void traverseChild(Selector parentSelector, HierarchicalModel parent, PropertyDescriptor property, Object value, String hrefSuffix) {
        this.traverse(value, parentSelector.getField(property), parent.createChild(property, value), hrefSuffix);
    }

    private void traverseChild(Selector parentSelector, HierarchicalModel parent, String property, Object value, String hrefSuffix) {
        this.traverse(value, parentSelector.getField(property), parent.createChild(property, value), hrefSuffix);
    }

    public Class<?> findClass(Object instance) {
        return this._classFinderStrategy.findClass(instance);
    }

    protected boolean isNotBean(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.isEnum() || Number.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz);
    }

    public URICreator getUriCreator() {
        return this._uriCreator;
    }

    public void setUriCreator(URICreator uriCreator) {
        this._uriCreator = uriCreator;
    }

    public URITemplateGenerator getUriTemplateGenerator() {
        return this._uriTemplateGenerator;
    }

    public void setUriTemplateGenerator(URITemplateGenerator uriTemplateGenerator) {
        this._uriTemplateGenerator = uriTemplateGenerator;
    }

    public void setFieldPopulatorRegistry(FieldPopulatorRegistry fieldPopulatorRegistry) {
        this._fieldPopulatorRegistry = fieldPopulatorRegistry;
    }

    public void setClassFinderStrategy(ClassFinderStrategy classFinderStrategy) {
        this._classFinderStrategy = classFinderStrategy;
    }

    public void setShowDefinition(boolean showDefinition) {
        this._showDefinition = showDefinition;
    }

    public void setShowHref(boolean showHref) {
        this._showHref = showHref;
    }

    private class DefaultClassFinderStrategy
    implements ClassFinderStrategy {
        private DefaultClassFinderStrategy() {
        }

        @Override
        public Class<?> findClass(Object instance) {
            return instance.getClass();
        }
    }
}

