/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.selector;

import org.skyscreamer.yoga.selector.CombinedSelector;
import org.skyscreamer.yoga.selector.CoreSelector;
import org.skyscreamer.yoga.selector.DefinedSelectorImpl;
import org.skyscreamer.yoga.selector.ParseSelectorException;
import org.skyscreamer.yoga.selector.Selector;

public class SelectorParser {
    public static final String HREF = "href";
    public static final String DEFINITION = "definition";

    public static Selector parseSelector(String selectorStr) {
        CoreSelector coreSelector = new CoreSelector();
        if (selectorStr != null) {
            try {
                return new CombinedSelector(coreSelector, SelectorParser.parse(selectorStr));
            }
            catch (ParseSelectorException e) {
                throw new IllegalArgumentException("Could not parse selector", e);
            }
        }
        return coreSelector;
    }

    public static DefinedSelectorImpl parse(String selectorExpression) throws ParseSelectorException {
        DefinedSelectorImpl selector = new DefinedSelectorImpl();
        if (selectorExpression.equals(":")) {
            return selector;
        }
        if (!selectorExpression.startsWith(":(")) {
            throw new ParseSelectorException("Selector must start with ':('");
        }
        StringBuilder selectorBuff = new StringBuilder(selectorExpression);
        int matchIndex = SelectorParser.getMatchingParenthesesIndex(selectorBuff, 1);
        selectorBuff.delete(matchIndex, selectorBuff.length());
        selectorBuff.delete(0, 2);
        while (selectorBuff.length() > 0) {
            SelectorParser.processNextSelectorField(selector, selectorBuff);
        }
        return selector;
    }

    private static int getMatchingParenthesesIndex(StringBuilder selector, int index) throws ParseSelectorException {
        int parenthesesCount = 1;
        while (parenthesesCount > 0 && index < selector.length() - 1) {
            if (selector.charAt(++index) == '(') {
                ++parenthesesCount;
            }
            if (selector.charAt(index) != ')') continue;
            --parenthesesCount;
        }
        if (parenthesesCount > 0) {
            throw new ParseSelectorException("More opening parentheses than closing parentheses");
        }
        return index;
    }

    private static void processNextSelectorField(DefinedSelectorImpl selector, StringBuilder selectorBuff) throws ParseSelectorException {
        int index = 0;
        boolean done = false;
        StringBuilder fieldNameBuilder = new StringBuilder();
        DefinedSelectorImpl subSelector = new DefinedSelectorImpl();
        while (!done) {
            if (selectorBuff.charAt(index) == ',') {
                done = true;
            } else if (selectorBuff.charAt(index) == ':') {
                done = true;
                int matchIndex = SelectorParser.getMatchingParenthesesIndex(selectorBuff, index + 1);
                subSelector = SelectorParser.parse(selectorBuff.substring(index, matchIndex + 1));
                if (selectorBuff.length() > matchIndex + 1 && selectorBuff.charAt(matchIndex + 1) != ',') {
                    throw new ParseSelectorException();
                }
                index = matchIndex + 1;
            } else {
                fieldNameBuilder.append(selectorBuff.charAt(index));
            }
            if (++index != selectorBuff.length()) continue;
            done = true;
        }
        selectorBuff.delete(0, index);
        String fieldName = fieldNameBuilder.toString();
        if (fieldName.equals(HREF)) {
            throw new IllegalArgumentException("href is a reserved keyword for selectors");
        }
        selector._fields.put(fieldName, subSelector);
    }
}

