/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.mapper;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.skyscreamer.yoga.mapper.ClassFinderStrategy;
import org.skyscreamer.yoga.mapper.HierarchicalModel;
import org.skyscreamer.yoga.mapper.enrich.Enricher;
import org.skyscreamer.yoga.mapper.enrich.HrefEnricher;
import org.skyscreamer.yoga.mapper.enrich.ModelDefinitionBuilder;
import org.skyscreamer.yoga.mapper.enrich.NavigationLinksEnricher;
import org.skyscreamer.yoga.metadata.PropertyUtil;
import org.skyscreamer.yoga.populator.DefaultFieldPopulatorRegistry;
import org.skyscreamer.yoga.populator.ExtraField;
import org.skyscreamer.yoga.populator.FieldPopulator;
import org.skyscreamer.yoga.populator.FieldPopulatorRegistry;
import org.skyscreamer.yoga.populator.FieldPopulatorUtil;
import org.skyscreamer.yoga.selector.Selector;

public class ResultTraverser {
    private FieldPopulatorRegistry _fieldPopulatorRegistry = new DefaultFieldPopulatorRegistry(new ArrayList());
    private List<Enricher> _enrichers = Arrays.asList(new HrefEnricher(), new ModelDefinitionBuilder(), new NavigationLinksEnricher());
    private ClassFinderStrategy _classFinderStrategy = new ClassFinderStrategy(){

        @Override
        public Class<?> findClass(Object instance) {
            return instance.getClass();
        }
    };

    public void traverse(Object instance, Selector fieldSelector, HierarchicalModel model, String hrefSuffix) {
        Class<?> instanceType = this.findClass(instance);
        this.addExtraInfo(instance, fieldSelector, model, instanceType, hrefSuffix);
        this.addProperties(instance, fieldSelector, model, instanceType, hrefSuffix);
    }

    protected <T> void addExtraInfo(Object instance, Selector fieldSelector, HierarchicalModel model, Class<T> instanceType, String hrefSuffix) {
        FieldPopulator<?> populator = this._fieldPopulatorRegistry.getFieldPopulator(instanceType);
        for (Enricher enricher : this._enrichers) {
            enricher.enrich(instance, fieldSelector, model, instanceType, hrefSuffix, populator);
        }
        this.addAnnotatedExtraFields(fieldSelector, model, hrefSuffix, populator, instance, instanceType);
    }

    private void addAnnotatedExtraFields(Selector fieldSelector, HierarchicalModel model, String hrefSuffix, FieldPopulator<?> populator, Object instance, Class<?> instanceType) {
        for (Method method : FieldPopulatorUtil.getPopulatorExtraFieldMethods(populator, instanceType)) {
            Object fieldValue;
            ExtraField extraField = method.getAnnotation(ExtraField.class);
            if (!fieldSelector.containsField(extraField.value())) continue;
            try {
                fieldValue = method.getParameterTypes().length == 0 ? method.invoke(populator, new Object[0]) : method.invoke(populator, instance);
            }
            catch (Exception e) {
                continue;
            }
            Selector childSelector = fieldSelector.getField(extraField.value());
            if (ResultTraverser.isPrimitive(fieldValue.getClass())) {
                if (fieldValue == null) continue;
                model.addSimple(extraField.value(), fieldValue);
                continue;
            }
            if (Iterable.class.isAssignableFrom(fieldValue.getClass())) {
                this.traverseIterable(childSelector, model, extraField.value(), (Iterable)fieldValue, hrefSuffix);
                continue;
            }
            this.traverseChild(childSelector, model, extraField.value(), fieldValue, hrefSuffix);
        }
    }

    protected void addProperties(Object instance, Selector fieldSelector, HierarchicalModel model, Class<?> instanceType, String hrefSuffix) {
        FieldPopulator<?> fieldPopulator = this._fieldPopulatorRegistry.getFieldPopulator(instanceType);
        for (PropertyDescriptor property : PropertyUtil.getReadableProperties(instanceType)) {
            try {
                boolean containsField = fieldSelector.containsField(property, fieldPopulator);
                if (!containsField) continue;
                Object value = PropertyUtils.getNestedProperty((Object)instance, (String)property.getName());
                Class<?> propertyType = property.getPropertyType();
                if (ResultTraverser.isPrimitive(propertyType)) {
                    if (value == null) continue;
                    model.addSimple(property, value);
                    continue;
                }
                if (Iterable.class.isAssignableFrom(propertyType)) {
                    this.traverseIterable(fieldSelector, model, property, (Iterable)value, hrefSuffix);
                    continue;
                }
                this.traverseChild(fieldSelector, model, property, value, hrefSuffix);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void traverseIterable(Selector fieldSelector, HierarchicalModel model, PropertyDescriptor property, Iterable<?> list, String hrefSuffix) {
        if (list == null) {
            return;
        }
        HierarchicalModel listModel = model.createList(property, list);
        for (Object o : list) {
            Class<?> type = this.findClass(o);
            if (ResultTraverser.isPrimitive(type)) {
                listModel.addSimple(property, list);
                continue;
            }
            this.traverseChild(fieldSelector, listModel, property, o, hrefSuffix);
        }
    }

    private void traverseIterable(Selector fieldSelector, HierarchicalModel model, String property, Iterable<?> list, String hrefSuffix) {
        if (list == null) {
            return;
        }
        HierarchicalModel listModel = model.createList(property, list);
        for (Object o : list) {
            Class<?> type = this.findClass(o);
            if (ResultTraverser.isPrimitive(type)) {
                listModel.addSimple(property, list);
                continue;
            }
            this.traverseChild(fieldSelector, listModel, property, o, hrefSuffix);
        }
    }

    private void traverseChild(Selector parentSelector, HierarchicalModel parent, PropertyDescriptor property, Object value, String hrefSuffix) {
        this.traverse(value, parentSelector.getField(property), parent.createChild(property, value), hrefSuffix);
    }

    private void traverseChild(Selector parentSelector, HierarchicalModel parent, String property, Object value, String hrefSuffix) {
        this.traverse(value, parentSelector.getField(property), parent.createChild(property, value), hrefSuffix);
    }

    public Class<?> findClass(Object instance) {
        return this._classFinderStrategy.findClass(instance);
    }

    public static boolean isPrimitive(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.isEnum() || Number.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz);
    }

    public void setFieldPopulatorRegistry(FieldPopulatorRegistry fieldPopulatorRegistry) {
        this._fieldPopulatorRegistry = fieldPopulatorRegistry;
    }

    public void setClassFinderStrategy(ClassFinderStrategy classFinderStrategy) {
        this._classFinderStrategy = classFinderStrategy;
    }

    public void setEnrichers(List<Enricher> enrichers) {
        this._enrichers = enrichers;
    }
}

