/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.metadata;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.skyscreamer.yoga.mapper.ResultTraverser;
import org.skyscreamer.yoga.metadata.MetaDataService;
import org.skyscreamer.yoga.metadata.PropertyMetaData;
import org.skyscreamer.yoga.metadata.PropertyUtil;
import org.skyscreamer.yoga.metadata.TypeMetaData;
import org.skyscreamer.yoga.populator.ExtraField;
import org.skyscreamer.yoga.populator.FieldPopulator;
import org.skyscreamer.yoga.populator.FieldPopulatorRegistry;
import org.skyscreamer.yoga.populator.FieldPopulatorUtil;
import org.skyscreamer.yoga.selector.Core;
import org.skyscreamer.yoga.util.NameUtil;

public class MapMetaDataServiceImpl
implements MetaDataService {
    private Map<String, Class<?>> _typeMappings;
    private Map<Class<?>, String> _typeToStringMap = new HashMap();
    private String rootMetaDataUrl;
    private FieldPopulatorRegistry _fieldPopulatorRegistry;

    public FieldPopulatorRegistry getFieldPopulatorRegistry() {
        return this._fieldPopulatorRegistry;
    }

    public void setFieldPopulatorRegistry(FieldPopulatorRegistry fieldPopulatorRegistry) {
        this._fieldPopulatorRegistry = fieldPopulatorRegistry;
    }

    public String getRootMetaDataUrl() {
        return this.rootMetaDataUrl;
    }

    public void setRootMetaDataUrl(String rootMetaDataUrl) {
        this.rootMetaDataUrl = rootMetaDataUrl;
    }

    public void setTypeMappings(Map<String, Class<?>> map) {
        this._typeMappings = map;
        this._typeToStringMap.clear();
        for (Map.Entry<String, Class<?>> entry : map.entrySet()) {
            this._typeToStringMap.put(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMappings() {
        return this._typeMappings;
    }

    @Override
    public Class<?> getTypeForName(String name) {
        return this._typeMappings.get(name);
    }

    @Override
    public String getNameForType(Class<?> type) {
        if (this._typeToStringMap.containsKey(type)) {
            return this._typeToStringMap.get(type);
        }
        for (Map.Entry<String, Class<?>> entry : this._typeMappings.entrySet()) {
            if (!entry.getValue().isAssignableFrom(type)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public TypeMetaData getMetaData(String name, String suffix) {
        return this.getMetaData(this.getTypeForName(name), suffix);
    }

    @Override
    public TypeMetaData getMetaData(Class<?> type, String suffix) {
        TypeMetaData result = new TypeMetaData();
        result.setName(NameUtil.getFormalName(type));
        this.addCoreFields(type, suffix, result);
        this.addPopulatorFields(type, suffix, result);
        return result;
    }

    protected void addCoreFields(Class<?> type, String suffix, TypeMetaData result) {
        for (PropertyDescriptor property : PropertyUtil.getReadableProperties(type)) {
            Method readMethod = property.getReadMethod();
            String name = property.getName();
            boolean core = readMethod.isAnnotationPresent(Core.class);
            this.addField(suffix, result, readMethod, name, core);
        }
    }

    protected void addPopulatorFields(Class<?> type, String suffix, TypeMetaData result) {
        FieldPopulator<?> fieldPopulator = null;
        if (this._fieldPopulatorRegistry != null) {
            fieldPopulator = this._fieldPopulatorRegistry.getFieldPopulator(type);
        }
        if (fieldPopulator == null) {
            return;
        }
        for (Method method : FieldPopulatorUtil.getPopulatorExtraFieldMethods(fieldPopulator, type)) {
            String name = method.getAnnotation(ExtraField.class).value();
            this.addField(suffix, result, method, name, false);
        }
    }

    protected PropertyMetaData addField(String suffix, TypeMetaData result, Method readMethod, String name, boolean core) {
        Class<?> propertyType = readMethod.getReturnType();
        PropertyMetaData propertyMetaData = new PropertyMetaData();
        result.getPropertyMetaData().add(propertyMetaData);
        propertyMetaData.setName(name);
        propertyMetaData.setIsCore(core);
        if (ResultTraverser.isPrimitive(propertyType)) {
            propertyMetaData.setType(propertyType == String.class ? "String" : propertyType.getName());
        } else if (Iterable.class.isAssignableFrom(propertyType) || propertyType.isArray()) {
            Class<?> collectionValueType = this.getCollectionType(readMethod, propertyType);
            String typeName = NameUtil.getFormalName(collectionValueType) + "[]";
            propertyMetaData.setType(typeName);
            this.addHref(propertyMetaData, collectionValueType, suffix);
        } else {
            propertyMetaData.setType(NameUtil.getFormalName(propertyType));
            this.addHref(propertyMetaData, propertyType, suffix);
        }
        return propertyMetaData;
    }

    protected Class<?> getCollectionType(Method readMethod, Class<?> propertyType) {
        Class collectionValueType = null;
        if (propertyType.isArray()) {
            collectionValueType = propertyType.getComponentType();
        } else {
            Type genericReturnType = readMethod.getGenericReturnType();
            if (genericReturnType instanceof ParameterizedType) {
                ParameterizedType zType = (ParameterizedType)genericReturnType;
                collectionValueType = (Class)zType.getActualTypeArguments()[0];
            }
        }
        return collectionValueType;
    }

    @Override
    public String getHref(Class<?> propertyType, String suffix) {
        String nameForType = this.getNameForType(propertyType);
        if (nameForType != null) {
            return this.getRootMetaDataUrl() + nameForType + "." + suffix;
        }
        return null;
    }

    protected void addHref(PropertyMetaData propertyMetaData, Class<?> propertyType, String suffix) {
        String href = this.getHref(propertyType, suffix);
        if (href != null) {
            propertyMetaData.setHref(href);
        }
    }
}

