/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.selector;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.skyscreamer.yoga.populator.FieldPopulator;
import org.skyscreamer.yoga.selector.Selector;

public class CombinedSelector
implements Selector {
    Collection<Selector> _selectors = new ArrayList<Selector>();

    public CombinedSelector(Selector ... selectors) {
        this(Arrays.asList(selectors));
    }

    public CombinedSelector(Iterable<Selector> selectors) {
        for (Selector selector : selectors) {
            if (selector == null) continue;
            this._selectors.add(selector);
        }
    }

    @Override
    public Selector getField(PropertyDescriptor propertyDescriptor) {
        ArrayList<Selector> children = new ArrayList<Selector>();
        for (Selector s : this._selectors) {
            children.add(s.getField(propertyDescriptor));
        }
        return new CombinedSelector(children);
    }

    @Override
    public Selector getField(String fieldName) {
        ArrayList<Selector> children = new ArrayList<Selector>();
        for (Selector s : this._selectors) {
            children.add(s.getField(fieldName));
        }
        return new CombinedSelector(children);
    }

    @Override
    public boolean containsField(PropertyDescriptor property, FieldPopulator<?> fieldPopulator) {
        for (Selector selector : this._selectors) {
            if (!selector.containsField(property, fieldPopulator)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsField(String property) {
        for (Selector selector : this._selectors) {
            if (!selector.containsField(property)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getFieldNames() {
        HashSet<String> result = new HashSet<String>();
        for (Selector selector : this._selectors) {
            result.addAll(selector.getFieldNames());
        }
        return result;
    }
}

