/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.selector;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import org.skyscreamer.yoga.annotations.Core;
import org.skyscreamer.yoga.annotations.ExtraField;
import org.skyscreamer.yoga.configuration.DefaultEntityConfigurationRegistry;
import org.skyscreamer.yoga.configuration.EntityConfigurationRegistry;
import org.skyscreamer.yoga.configuration.YogaEntityConfiguration;
import org.skyscreamer.yoga.metadata.PropertyUtil;
import org.skyscreamer.yoga.selector.ExtraFieldProperty;
import org.skyscreamer.yoga.selector.MapSelector;
import org.skyscreamer.yoga.selector.PojoProperty;
import org.skyscreamer.yoga.selector.Property;

public class CoreSelector
extends MapSelector {
    private EntityConfigurationRegistry _entityConfigurationRegistry = new DefaultEntityConfigurationRegistry();

    public CoreSelector(EntityConfigurationRegistry entityConfigurationRegistry) {
        this._entityConfigurationRegistry = entityConfigurationRegistry;
    }

    public CoreSelector() {
    }

    public void setEntityConfigurationRegistry(EntityConfigurationRegistry entityConfigurationRegistry) {
        this._entityConfigurationRegistry = entityConfigurationRegistry;
    }

    @Override
    protected Collection<Property> getFieldCollection(Class<?> instanceType) {
        Collection<Property> properties = (Collection<Property>)this.descriptors.get(instanceType);
        if (properties == null) {
            properties = this.createFields(instanceType);
            this.descriptors.put(instanceType, properties);
        }
        return properties;
    }

    private Collection<Property> createFields(Class<?> instanceType) {
        ArrayList<Property> response = new ArrayList<Property>();
        List<PropertyDescriptor> readableProperties = PropertyUtil.getReadableProperties(instanceType);
        Collection<String> allowedCoreFields = this.getAllowedCoreFields(instanceType);
        if (allowedCoreFields == null) {
            for (PropertyDescriptor property : readableProperties) {
                if (!property.getReadMethod().isAnnotationPresent(Core.class)) continue;
                response.add(new PojoProperty(property));
            }
        } else {
            for (PropertyDescriptor property : readableProperties) {
                if (!allowedCoreFields.contains(property.getName())) continue;
                response.add(new PojoProperty(property));
            }
        }
        return response;
    }

    protected <T> Collection<String> getAllowedCoreFields(Class<T> instanceType) {
        YogaEntityConfiguration<T> entityConfiguration = this._entityConfigurationRegistry == null ? null : this._entityConfigurationRegistry.getEntityConfiguration(instanceType);
        return entityConfiguration != null ? entityConfiguration.getCoreFields() : null;
    }

    @Override
    public Collection<Property> getAllPossibleFields(Class<?> instanceType) {
        YogaEntityConfiguration<?> entityConfiguration;
        TreeMap<String, Property> response = new TreeMap<String, Property>();
        List<PropertyDescriptor> readableProperties = PropertyUtil.getReadableProperties(instanceType);
        for (PropertyDescriptor property : readableProperties) {
            response.put(property.getName(), new PojoProperty(property));
        }
        YogaEntityConfiguration<?> yogaEntityConfiguration = entityConfiguration = this._entityConfigurationRegistry == null ? null : this._entityConfigurationRegistry.getEntityConfiguration(instanceType);
        if (entityConfiguration != null) {
            for (Method method : entityConfiguration.getExtraFieldMethods()) {
                String name = method.getAnnotation(ExtraField.class).value();
                response.put(name, new ExtraFieldProperty(name, entityConfiguration, method));
            }
        }
        return response.values();
    }
}

