/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.selector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.skyscreamer.yoga.configuration.EntityConfigurationRegistry;
import org.skyscreamer.yoga.configuration.YogaEntityConfiguration;
import org.skyscreamer.yoga.selector.NamedProperty;
import org.skyscreamer.yoga.selector.Property;
import org.skyscreamer.yoga.selector.Selector;

public class FieldSelector
implements Selector {
    protected Map<String, FieldSelector> subSelectors = new HashMap<String, FieldSelector>();
    protected EntityConfigurationRegistry _entityConfigurationRegistry;

    public FieldSelector(EntityConfigurationRegistry entityConfigurationRegistry) {
        this._entityConfigurationRegistry = entityConfigurationRegistry;
    }

    @Override
    public FieldSelector getChildSelector(Class<?> instanceType, String fieldName) {
        return this.getSelector(fieldName);
    }

    public FieldSelector getSelector(String fieldName) {
        return this.subSelectors.get(fieldName);
    }

    @Override
    public boolean containsField(Class<?> instanceType, String property) {
        return this.containsField(property);
    }

    public boolean containsField(String property) {
        return this.subSelectors.containsKey(property);
    }

    public int getFieldCount() {
        return this.subSelectors.size();
    }

    @Override
    public Collection<Property> getSelectedFields(Class<?> instanceType, Object instance) {
        Set<String> fieldNames = this.getFieldNames();
        this.removeNonSupportedFields(instanceType, fieldNames);
        ArrayList<Property> selected = new ArrayList<Property>();
        for (String name : fieldNames) {
            selected.add(new NamedProperty(name));
        }
        return selected;
    }

    public <T> void removeNonSupportedFields(Class<T> instanceType, Set<String> fieldNames) {
        YogaEntityConfiguration<T> entityConfiguration = this._entityConfigurationRegistry.getEntityConfiguration(instanceType);
        if (entityConfiguration != null && entityConfiguration.getSelectableFields() != null) {
            Iterator<String> iter = fieldNames.iterator();
            while (iter.hasNext()) {
                String fieldName = iter.next();
                if (entityConfiguration.getSelectableFields().contains(fieldName)) continue;
                iter.remove();
            }
        }
    }

    public Set<String> getFieldNames() {
        return this.subSelectors.keySet();
    }

    public Map<String, FieldSelector> getFields() {
        return this.subSelectors;
    }

    public void register(String fieldName, FieldSelector subSelector) {
        this.subSelectors.put(fieldName, subSelector);
    }

    @Override
    public Collection<Property> getAllPossibleFields(Class<?> instanceType) {
        ArrayList<Property> allFields = new ArrayList<Property>();
        for (String name : this.getFieldNames()) {
            allFields.add(new NamedProperty(name));
        }
        return allFields;
    }

    @Override
    public boolean isInfluencedExternally() {
        return true;
    }
}

