/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.view;

import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.skyscreamer.yoga.exceptions.ParseSelectorException;
import org.skyscreamer.yoga.listener.RenderingListenerRegistry;
import org.skyscreamer.yoga.mapper.ResultTraverser;
import org.skyscreamer.yoga.mapper.YogaRequestContext;
import org.skyscreamer.yoga.selector.CoreSelector;
import org.skyscreamer.yoga.selector.MapSelector;
import org.skyscreamer.yoga.selector.Selector;
import org.skyscreamer.yoga.selector.parser.SelectorParser;
import org.skyscreamer.yoga.util.ClassFinderStrategy;
import org.skyscreamer.yoga.util.NameUtil;

public abstract class AbstractYogaView {
    protected ResultTraverser _resultTraverser = new ResultTraverser();
    protected ClassFinderStrategy _classFinderStrategy;
    protected SelectorParser _selectorParser;
    protected RenderingListenerRegistry _registry = new RenderingListenerRegistry();
    protected MapSelector _selector = new CoreSelector();

    public void setResultTraverser(ResultTraverser resultTraverser) {
        this._resultTraverser = resultTraverser;
    }

    public void setSelectorParser(SelectorParser selectorParser) {
        this._selectorParser = selectorParser;
    }

    public void setRegistry(RenderingListenerRegistry registry) {
        this._registry = registry;
    }

    public void setSelector(MapSelector selector) {
        this._selector = selector;
    }

    public void setClassFinderStrategy(ClassFinderStrategy classFinderStrategy) {
        this._classFinderStrategy = classFinderStrategy;
        this._resultTraverser.setClassFinderStrategy(classFinderStrategy);
    }

    public final void render(HttpServletRequest request, HttpServletResponse response, Object value, OutputStream os) throws Exception {
        YogaRequestContext context = new YogaRequestContext(this.getHrefSuffix(), this._selectorParser, request, response, this._registry.getListeners());
        Selector selector = this.getSelector(request);
        this.render(selector, value, context, os);
    }

    protected Selector getSelector(HttpServletRequest request) throws ParseSelectorException {
        String selectorString = request.getParameter("selector");
        return this._selectorParser.parseSelector(selectorString, this._selector);
    }

    protected String getClassName(Object obj) {
        Class<?> type = this._classFinderStrategy.findClass(obj);
        return NameUtil.getName(type);
    }

    public abstract String getContentType();

    protected abstract void render(Selector var1, Object var2, YogaRequestContext var3, OutputStream var4) throws Exception;

    public abstract String getHrefSuffix();
}

