/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.listener;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import org.skyscreamer.yoga.configuration.EntityConfigurationRegistry;
import org.skyscreamer.yoga.configuration.YogaEntityConfiguration;
import org.skyscreamer.yoga.listener.RenderingEvent;
import org.skyscreamer.yoga.listener.RenderingEventType;
import org.skyscreamer.yoga.listener.RenderingListener;
import org.skyscreamer.yoga.metadata.PropertyUtil;
import org.skyscreamer.yoga.model.MapHierarchicalModel;

public class ModelDefinitionListener
implements RenderingListener {
    private EntityConfigurationRegistry _entityConfigurationRegistry;

    public void setEntityConfigurationRegistry(EntityConfigurationRegistry entityConfigurationRegistry) {
        this._entityConfigurationRegistry = entityConfigurationRegistry;
    }

    @Override
    public void eventOccurred(RenderingEvent event) {
        YogaEntityConfiguration<?> entityConfiguration;
        if (event.getType() != RenderingEventType.POJO_CHILD || event.getSelector().isInfluencedExternally()) {
            return;
        }
        ArrayList<String> definition = new ArrayList<String>();
        Class<?> instanceType = event.getValueType();
        for (PropertyDescriptor property : PropertyUtil.getReadableProperties(instanceType)) {
            definition.add(property.getName());
        }
        if (this._entityConfigurationRegistry != null && (entityConfiguration = this._entityConfigurationRegistry.getEntityConfiguration(instanceType)) != null) {
            definition.addAll(entityConfiguration.getExtraFieldNames());
        }
        ((MapHierarchicalModel)event.getModel()).addProperty("definition", definition);
    }
}

