/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.metadata;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.skyscreamer.yoga.metadata.MetaDataRegistry;
import org.skyscreamer.yoga.metadata.PropertyMetaData;
import org.skyscreamer.yoga.metadata.TypeMetaData;
import org.skyscreamer.yoga.selector.CoreSelector;
import org.skyscreamer.yoga.selector.Property;
import org.skyscreamer.yoga.util.NameUtil;
import org.skyscreamer.yoga.util.ObjectUtil;

public class DefaultMetaDataRegistry
implements MetaDataRegistry {
    private Map<String, Class<?>> _typeMappings;
    private Map<Class<?>, String> _typeToStringMap = new HashMap();
    private String rootMetaDataUrl;
    private CoreSelector _coreSelector;

    public void setCoreSelector(CoreSelector coreSelector) {
        this._coreSelector = coreSelector;
    }

    public void setRootMetaDataUrl(String rootMetaDataUrl) {
        this.rootMetaDataUrl = rootMetaDataUrl;
    }

    public void setTypeMappings(Map<String, Class<?>> map) {
        this._typeMappings = map;
        this._typeToStringMap.clear();
        for (Map.Entry<String, Class<?>> entry : map.entrySet()) {
            this._typeToStringMap.put(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public Collection<String> getTypes() {
        return this._typeMappings.keySet();
    }

    private Class<?> getTypeForName(String name) {
        return this._typeMappings.get(name);
    }

    private String getNameForType(Class<?> type) {
        if (this._typeToStringMap.containsKey(type)) {
            return this._typeToStringMap.get(type);
        }
        for (Map.Entry<String, Class<?>> entry : this._typeMappings.entrySet()) {
            if (!entry.getValue().isAssignableFrom(type)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public TypeMetaData getMetaData(String name, String suffix) {
        return this.getMetaData(this.getTypeForName(name), suffix);
    }

    private TypeMetaData getMetaData(Class<?> type, String suffix) {
        TypeMetaData result = new TypeMetaData();
        result.setName(NameUtil.getFormalName(type));
        this.addFields(type, suffix, result);
        return result;
    }

    protected void addFields(Class<?> type, String suffix, TypeMetaData result) {
        Collection<Property> allFields = this._coreSelector.getAllPossibleFields(type);
        HashSet<String> coreFieldName = new HashSet<String>();
        for (Property property : this._coreSelector.getSelectedFields(type)) {
            coreFieldName.add(property.name());
        }
        for (Property property : allFields) {
            Method readMethod = property.getReadMethod();
            Class<?> propertyType = readMethod.getReturnType();
            PropertyMetaData propertyMetaData = new PropertyMetaData();
            String name = property.name();
            propertyMetaData.setName(name);
            propertyMetaData.setIsCore(coreFieldName.contains(name));
            if (ObjectUtil.isPrimitive(propertyType)) {
                propertyMetaData.setType(propertyType == String.class ? "String" : propertyType.getName());
            } else if (Iterable.class.isAssignableFrom(propertyType) || propertyType.isArray()) {
                Class<?> collectionValueType = this.getCollectionType(readMethod, propertyType);
                String typeName = NameUtil.getFormalName(collectionValueType) + "[]";
                propertyMetaData.setType(typeName);
                this.addHref(propertyMetaData, collectionValueType, suffix);
            } else {
                propertyMetaData.setType(NameUtil.getFormalName(propertyType));
                this.addHref(propertyMetaData, propertyType, suffix);
            }
            result.getPropertyMetaData().add(propertyMetaData);
        }
    }

    protected Class<?> getCollectionType(Method readMethod, Class<?> propertyType) {
        Class collectionValueType = null;
        if (propertyType.isArray()) {
            collectionValueType = propertyType.getComponentType();
        } else {
            Type genericReturnType = readMethod.getGenericReturnType();
            if (genericReturnType instanceof ParameterizedType) {
                ParameterizedType zType = (ParameterizedType)genericReturnType;
                collectionValueType = (Class)zType.getActualTypeArguments()[0];
            }
        }
        return collectionValueType;
    }

    @Override
    public String getMetadataHref(Class<?> propertyType, String suffix) {
        String nameForType = this.getNameForType(propertyType);
        if (nameForType != null) {
            return this.rootMetaDataUrl + nameForType + "." + suffix;
        }
        return null;
    }

    protected void addHref(PropertyMetaData propertyMetaData, Class<?> propertyType, String suffix) {
        String href = this.getMetadataHref(propertyType, suffix);
        if (href != null) {
            propertyMetaData.setHref(href);
        }
    }
}

