/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.selector;

import java.util.Collection;
import java.util.TreeMap;
import org.skyscreamer.yoga.selector.Property;
import org.skyscreamer.yoga.selector.Selector;

public class CompositeSelector
implements Selector {
    private Selector coreSelector;
    private Selector fieldSelector;

    public CompositeSelector(Selector coreSelector, Selector fieldSelector) {
        this.coreSelector = coreSelector;
        this.fieldSelector = fieldSelector;
    }

    @Override
    public Selector getChildSelector(Class<?> instanceType, String fieldName) {
        Selector fieldSelectorChild = this.fieldSelector.getChildSelector(instanceType, fieldName);
        Selector coreSelectorChild = this.coreSelector.getChildSelector(instanceType, fieldName);
        if (fieldSelectorChild == null) {
            return coreSelectorChild;
        }
        return new CompositeSelector(coreSelectorChild, fieldSelectorChild);
    }

    @Override
    public boolean containsField(Class<?> instanceType, String property) {
        return this.coreSelector.containsField(instanceType, property) || this.fieldSelector.containsField(instanceType, property);
    }

    @Override
    public Collection<Property> getSelectedFields(Class<?> instanceType) {
        TreeMap<String, Property> response = new TreeMap<String, Property>();
        Collection<Property> selectedFields = this.coreSelector.getSelectedFields(instanceType);
        for (Property property : selectedFields) {
            response.put(property.name(), property);
        }
        Collection<Property> fieldSelectorChildren = this.fieldSelector.getSelectedFields(instanceType);
        Collection<Property> allMapFields = this.coreSelector.getAllPossibleFields(instanceType);
        for (Property property : fieldSelectorChildren) {
            if (response.containsKey(property.name())) continue;
            for (Property mapProp : allMapFields) {
                if (!mapProp.name().equals(property.name())) continue;
                response.put(mapProp.name(), mapProp);
            }
        }
        return response.values();
    }

    @Override
    public Collection<Property> getAllPossibleFields(Class<?> instanceType) {
        return this.coreSelector.getAllPossibleFields(instanceType);
    }

    @Override
    public boolean isInfluencedExternally() {
        return true;
    }
}

